package com.icetech.park.domain.entity.park;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 车场广告管理
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2021-09-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_park_advert")
public class ParkAdvert implements Serializable {

    private static final long serialVersionUID=1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 车场id
     */
    private Integer parkId;

    /**
     * 弹框车牌页面广告开关  0：关闭，1：开启 默认1
     */
    private Boolean platepageAd;
    /**
     * banner位置关闭
     */
    private Boolean platepageAdBanner;

    /**
     * 收银台广告开关 0：关闭  1：开启 默认1
     */
    private Boolean cashregisterAd;
    /**
     * 收银台banner位置关闭
     */
    private Boolean cashregisterAdBanner;

    /**
     * 完成页广告开关 0：关闭，1：开启 默认1
     */
    private Boolean completepageAd;

    /**
     * 操作人
     */
    private String operAccount;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;


}
