package com.icetech.park.domain.entity.park;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2023-06-14 16:50
 * @desc 泊斯特要初始化的车场
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class InitBstPark implements Serializable {

    /**
     * 车场id
     */
    private Integer parkId;

    /**
     * 车场编号
     */
    private String parkCode;

    /**
     * 车场名称
     */
    private String parkName;

    /**
     * 省份名称
     */
    private String provinceName;

    /**
     * 城市名称
     */
    private String cityName;

    /**
     * 区县名称
     */
    private String districtName;
}
