package com.icetech.park.domain.entity.park;

import com.icetech.common.annotation.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2024-03-21 16:13
 * @desc 出场识别
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ExitIdentify implements Serializable {
    /** 订单号 */
    protected String orderNum;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 车场编号
     */
    private String parkCode;

    /**
     * 车牌号
     */
    @NotNull
    private String plateNum;

    /**
     * 辆类型:1临时车;2月卡车;3特殊车辆;4VIP车辆;5预约车辆;6储值卡车
     */
    @NotNull
    private Integer type;


    /**
     * 总金额，从车辆入场至当前时间计费的总费用
     */
    private String totalAmount;

    /**
     * 已缴金额
     */
    private String paidAmount;

    /**
     * 优惠金额，已使用过优惠总金额
     */
    private String discountAmount;

    /**
     * 本次优惠金额，从上次支付时间至当前时间优惠金额
     */
    private String discountPrice;

    /**
     * 本次应付金额:unpayPrice + discountPrice + discountAmount + paidAmount = totalAmount
     */
    private String unpayPrice;

    /**
     * 本停车总时长，单位秒
     */
    private Long parkTime;

    /**
     * 通道编号
     */
    private String channelCode;

    /**
     * 通道名称
     */
    private String channelName;

    /**
     * 支付链接
     */
    private String qrCodeUrl;

    /**
     * 禁止离场类型:11黑名单车;23无入场记录；14无牌车允许进出;25需缴费;41不允许临时车出;
     */
    private Integer reasonType;

    /**
     * 识别时间
     */
    private Long timestamp;

    /** 本次停车计费的时间（unix时间戳） */
    protected Long queryTime;

    /**
     * 入场时间
     */
    protected Long enterTime;
}
