package com.icetech.park.domain.entity.park;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalTime;
import java.util.Date;

/**
 * 通道权限扩展表(分时段专用)
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @date 2022-12-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_channel_rule_extend")
public class ChannelRuleExtend implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 车场ID
     */
    private Integer parkId;

    /**
     * 通道ID
     */
    private Integer channelId;

    /**
     * 工作日/非工作日标识，1：工作日，0：非工作日，区分工作日和非工作日时生效
     */
    private Integer workDay;

    /**
     * 开始时间
     */
    private Date startDate;

    /**
     * 结束时间类型，1：永不结束，2：指定时间
     */
    private Integer endDateType;

    /**
     * 结束时间
     */
    private Date endDate;

    /**
     * 不在开始至结束时间范围内的规则，1：所有车可进，2：所有车不可进
     */
    private Integer outsideRule;

    /**
     * 重复类型，1：每天重复，2：自定义
     */
    private Integer repeatType;

    /**
     * 频率类型，1：按周重复，2：按月重复，重复类型为自定义时生效
     */
    private Integer frequencyType;

    /**
     * 重复频率描述，按周重复时，描述周几，如周一、周四时，此值为1,4，按月重复时，描述几号，如每月1号、10、30号，此值为1,10,30，重复类型为自定义时生效
     */
    private String frequencyDesc;

    /**
     * 分时段的开始时间
     */
    private LocalTime startTime;

    /**
     * 分时段的结束时间
     */
    private LocalTime endTime;

    /**
     * 允许临时车进出 0:不允许  1：允许 默认1
     */
    private Integer isAllowTempcarrun;

    /**
     * 允许无牌车扫码进出 0:不允许  1：允许 默认1
     */
    private Integer isAllowNocardrun;

    /**
     * 黄牌车是否允许进 0:不允许  1：允许 默认1
     */
    private Integer isAllowYellowcarrun;

    /**
     * 开启二维码扫码进出0：不允许，1：允许 默认0 此标识不再使用
     */
    private Integer isOpenQrcodetype;

    /**
     * 允许新能源车辆进出 0：不允许 1：允许 默认1
     */
    private Integer isAllowNewenergycarrun;

    /**
     * 允许预约车进出0：不允许，1：允许
     */
    private Integer isAllowVisitCar;

    /**
     * 允月卡车车进出0：不允许，1：允许
     */
    private Integer isAllowMonthCar;

    /**
     * 允许黑名单车进出0：不允许，1：允许
     */
    private Integer isAllowBackCar;

    /**
     * 允许Vip车进出0：不允许，1：允许
     */
    private Integer isAllowVipCar;

    /**
     * 车场类型id，多个以逗号隔开
     */
    private String vipCarTypeId;

    /**
     * 允许多位多车月卡车进出1=是 0=否
     */
    private Integer isAllowAbcar;

    /**
     * 允许蓝牌车进出 0:不允许  1：允许 默认1
     */
    private Integer isAllowBluerun;

    /**
     * 允许储值卡车进入 0:不允许  1：允许 默认1
     */
    private Integer isAllowStoredCar;

    /**
     * 状态 0正常 1冻结
     */
    private Integer status;

    /**
     * 添加时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 添加人
     */
    private String adder;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 更新人
     */
    private String updateUser;


}
