package com.icetech.park.domain.entity.more;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;

/**
 * 多车场月卡信息表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2024-05-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@AllArgsConstructor
@Builder
@TableName("ice_more_month_info")
public class MoreMonthInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 申办性质 1个人 2公司
     */
    private Integer cardProperty;

    /**
     * 月卡所属人姓名/公司名称
     */
    private String cardOwner;

    /**
     * 手机号码
     */
    private String phone;

    /**
     * 车位数
     */
    private Integer plotCount;

    /**
     * 购买数量
     */
    private Integer buyCount;

    /**
     * 支付方式(0 现金，1 银行卡 2：微信 3：支付宝)
     */
    private Integer payMethod;

    /**
     * 支付渠道 1 云平台 2：App 3：公众号
     */
    private Integer payChannel;

    /**
     * 月卡有效开始日期
     */
    private Date startTime;

    /**
     * 月卡有效结束日期
     */
    private Date endTime;

    /**
     * 月卡状态 1 生效中 2 待生效 3 已退费 4 已过期 5 冻结 6暂停
     */
    private Integer cardStatus;

    /**
     * 操作人
     */
    private String operAccount;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 修改时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 状态（0：正常，1：删除，默认0）
     */
    private Integer deleteStatus;

    /**
     * 车主地址
     */
    private String mainAddress;


}
