package com.icetech.park.domain.entity.catched;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Auther: lisc
 * @Date: 2018/10/11 14:16
 * @Description: 无牌车进出场记录
 */
@TableName("ice_noplate_record")
@Data
public class NoplateRecord implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键自增长
     */
    @TableId(value = "id",type= IdType.AUTO )
    private Long id;
    /**
     * 用户统一唯一标识
     */
    private String unionId;
    /**
     * 停车场编号,平台编号
     */
    private String parkCode;
    /**
     * 车牌号
     */
    private String plateNum;
    /**
     * 车牌类型{1:无牌车,2:有牌车}
     */
    private String type;
    /**
     * 状态{1:未入场,2:已入场,3:已离场}
     */
    private String status;
    /**
     * 进场通道号
     */
    private String enterChannelId;
    /**
     * 出场通道号
     */
    private String exitChannelId;
    /**
     * 进场时间
     */
    private Date enterTime;
    /**
     * 出场时间
     */
    private Date exitTime;
    /**
     * 是否为主通道
     */
    private Integer isMaster;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;

}
