package com.icetech.park.domain.entity;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 本地平台对账汇总表
 * </p>
 *
 * @author fangct
 * @since 2019-08-03
 */
@Data
public class Reconciliation {

    private static final long serialVersionUID = 1L;

    private Integer id;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 账单日期
     */
    private String reportDate;

    /**
     * 本地账单总数
     */
    private Integer localCount;

    /**
     * 本地账单总应收
     */
    private BigDecimal localPriceTotal;

    /**
     * 本地账单总实收
     */
    private BigDecimal localPricePaid;

    /**
     * 本地账单总优惠
     */
    private BigDecimal localPriceDiscount;

    /**
     * 本地账单实际收钞
     */
    private BigDecimal localActualCash;

    /**
     * 本地账单红包找零
     */
    private BigDecimal localRedpackRet;

    /**
     * 平台账单总数
     */
    private Integer platformCount;

    /**
     * 平台账单总应收
     */
    private BigDecimal platformPriceTotal;

    /**
     * 平台账单总实收
     */
    private BigDecimal platformPricePaid;

    /**
     * 平台账单总优惠
     */
    private BigDecimal platformPriceDiscount;

    /**
     * 平台账单实际收钞
     */
    private BigDecimal platformActualCash;

    /**
     * 平台账单红包找零
     */
    private BigDecimal platformRedpackRet;

    /**
     * 对账结果，1：对账一致 2：对账不一致3：对账文件未上报
     */
    private Integer result;

    private Date createTime;

    private Date updateTime;


}
