package com.icetech.park.domain.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 进出口报警处理表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2021-07-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_channel_alarm_handler")
public class ChannelAlarmHandler implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 通道报警id
     */
    private Integer channelAlarmId;

    /**
     * 车场id
     */
    private Integer parkId;

    /**
     * 通道编号
     */
    private String channelCode;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 描述
     */
    private String remark;

    /**
     * 通道图片
     */
    private String image;

    /**
     * 滞留时间
     */
    private Date alarmTime;
    
    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 操作人
     */
    private String operator;


}
