package com.icetech.park.domain.entity;

import lombok.Data;
import lombok.Getter;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 进出口报警记录表
 * </p>
 *
 * @author fangct
 * @since 2020-06-16
 */
@Data
public class ChannelAlarm implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键自增长id
     */
    private Integer id;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 通道编号
     */
    private String channelCode;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 报警类型(1查询费用失败，2缴费未抬杆. 3云翌呼叫， 4 滞留车辆时间算法)
     */
    private Integer alarmType;

    /**
     * 报警状态（1未处理2已处理3超时未处理）
     */
    private Integer status;

    /**
     * 描述
     */
    private String remark;

    /**
     * 通道图片
     */
    private String image;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 操作人
     */
    private String operator;

    public enum Status {
        未处理(1), 已处理(2), 超时未处理(3);
        @Getter
        public int status;
        private Status(int status){
            this.status = status;
        }
    }

}
