package com.icetech.order.service.impl;

import com.icetech.order.dao.ReenterRecordDao;
import com.icetech.order.domain.entity.ReenterRecord;
import com.icetech.order.service.ReenterRecordService;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 重复入场记录表 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @date 2023-03-08
 */
@Service
public class ReenterRecordServiceImpl extends BaseServiceImpl<ReenterRecordDao, ReenterRecord> implements ReenterRecordService {

    /**
     * Description: 根据ID查询 重复入场记录表对象信息 <br>
     * Version1.0 2023-03-08 by fangct创建
     *
     * @param id 对象id
     * @return ReenterRecord
     */
    @Override
    public ReenterRecord getReenterRecordById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  重复入场记录表对象信息 <br>
     * Version1.0 2023-03-08 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addReenterRecord (ReenterRecord entity) {
        return save(entity);
    }

    /**
     * Description: 修改 重复入场记录表对象信息 <br>
     * Version1.0 2023-03-08 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyReenterRecord (ReenterRecord entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  重复入场记录表对象信息 <br>
     * Version1.0 2023-03-08 by fangct创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeReenterRecordById (Long id) {
        return removeById(id);
    }

}
