package com.icetech.order.service.impl;

import com.icetech.order.dao.OrderTagsDao;
import com.icetech.order.domain.entity.OrderTags;
import com.icetech.order.service.OrderTagsService;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 订单标签关联表 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @date 2021-11-10
 */
@Service
public class OrderTagsServiceImpl extends BaseServiceImpl<OrderTagsDao, OrderTags> implements OrderTagsService {
    @Autowired
    private OrderTagsDao orderTagsDao;

    /**
     * 1：多位多车占用，2：使用该车上一次的入场时间计费，3：欠费车辆，4：折返回场，5：虚假车牌，6：补缴车辆
     */
    private List<Integer> types = Arrays.asList(3, 4, 5, 6);

    @Override
    public OrderTags getListByOrderNumAndTagId(String orderNum, Integer tagId, Long regionId) {
        return orderTagsDao.selectByOrderNum(orderNum, tagId, regionId);
    }

    /**
     * Description: 根据ID查询 订单标签关联表对象信息 <br>
     * Version1.0 2021-11-10 by fangct创建
     *
     * @param id 对象id
     * @return OrderTags
     */
    @Override
    public OrderTags getOrderTagsById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  订单标签关联表对象信息 <br>
     * Version1.0 2021-11-10 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addOrderTags (OrderTags entity) {
        return save(entity);
    }

    /**
     * Description: 修改 订单标签关联表对象信息 <br>
     * Version1.0 2021-11-10 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyOrderTags (OrderTags entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  订单标签关联表对象信息 <br>
     * Version1.0 2021-11-10 by fangct创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeOrderTagsById (Long id) {
        return removeById(id);
    }

    @Override
    public List<OrderTags> getListByOrderNum(String orderNum, Integer type) {
        List<OrderTags> tags = list(OrderTags.builder()
                .orderNum(orderNum)
                .build());
        if (CollectionUtils.isEmpty(tags)) {
            return Collections.emptyList();
        }
        if (type != null && type == 0) {
         return tags.stream()
                    .filter(Objects::nonNull)
                    .filter(orderTag -> orderTag.getTagId() != null)
                    .filter(tag -> types.contains(tag.getTagId()))
                    .collect(Collectors.toList());
        }
        return tags;
    }

}
