package com.icetech.order.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.order.dao.OrderRemarkMapper;
import com.icetech.order.domain.entity.OrderRemark;
import com.icetech.order.service.OrderRemarkService;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 订单备注表 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2024-01-05
 */
@Service
public class OrderRemarkServiceImpl extends BaseServiceImpl<OrderRemarkMapper, OrderRemark> implements OrderRemarkService {

    /**
     * Description: 根据ID查询 订单备注表对象信息 <br>
     * Version1.0 2024-01-05 by wanggang创建
     *
     * @param id 对象id
     * @return OrderRemark
     */
    @Override
    public OrderRemark getOrderRemarkById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  订单备注表对象信息 <br>
     * Version1.0 2024-01-05 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addOrderRemark (OrderRemark entity) {
        return save(entity);
    }

    /**
     * Description: 修改 订单备注表对象信息 <br>
     * Version1.0 2024-01-05 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyOrderRemark (OrderRemark entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  订单备注表对象信息 <br>
     * Version1.0 2024-01-05 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeOrderRemarkById (Long id) {
        return removeById(id);
    }

    @Override
    public OrderRemark getByOrderNumAndType(String orderNum, Integer type) {
        OrderRemark orderRemark = getOne(Wrappers.lambdaQuery(OrderRemark.class)
                .eq(OrderRemark::getOrderNum, orderNum)
                .eq(OrderRemark::getType, type));
        return orderRemark;
    }

}
