package com.icetech.order.service.impl;

import com.icetech.order.dao.OrderRefundRecordMapper;
import com.icetech.order.domain.entity.OrderRefundRecord;
import com.icetech.order.service.OrderRefundRecordService;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 退款记录表 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2022-04-20
 */
@Service
public class OrderRefundRecordServiceImpl extends BaseServiceImpl<OrderRefundRecordMapper, OrderRefundRecord> implements OrderRefundRecordService {

    /**
     * Description: 根据ID查询 退款记录表对象信息 <br>
     * Version1.0 2022-04-20 by wangzhiwei创建
     *
     * @param id 对象id
     * @return OrderRefundRecord
     */
    @Override
    public OrderRefundRecord getOrderRefundRecordById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  退款记录表对象信息 <br>
     * Version1.0 2022-04-20 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addOrderRefundRecord (OrderRefundRecord entity) {
        return save(entity);
    }

    /**
     * Description: 修改 退款记录表对象信息 <br>
     * Version1.0 2022-04-20 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyOrderRefundRecord (OrderRefundRecord entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  退款记录表对象信息 <br>
     * Version1.0 2022-04-20 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeOrderRefundRecordById (Long id) {
        return removeById(id);
    }

}
