package com.icetech.order.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.pagehelper.PageHelper;
import com.icetech.common.utils.NumberUtils;
import com.icetech.order.domain.dto.DiscountDto;
import com.icetech.third.anno.DS_SLAVE;
import com.icetech.cloudcenter.api.order.OrderDiscountService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.order.dao.OrderDiscountDao;
import com.icetech.third.dao.send.SendinfoDao;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.order.query.OrderDiscountQuery;
import com.icetech.cloudcenter.domain.request.DiscountRequest;
import com.icetech.cloudcenter.domain.request.QueryDiscountRequest;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.DataCollectionEnum;
import com.icetech.common.constants.SqlConstant;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.PageQuery;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
@Service("orderDiscountService")
public class OrderDiscountServiceImpl extends BaseServiceImpl<OrderDiscountDao, OrderDiscount> implements OrderDiscountService {
    @Autowired
    private OrderDiscountDao orderDiscountDao;
    @Autowired
    private SendinfoDao sendinfoDao;
    @Autowired
    private ParkService parkService;

    /**
     * 更新订单的状态
     * @param discountRequest
     * @return
     */
    @Override
    public ObjectResponse modifyDiscount(DiscountRequest discountRequest) {
        OrderDiscountQuery orderDiscountQuery = new OrderDiscountQuery();
        BeanUtils.copyProperties(discountRequest, orderDiscountQuery);
        orderDiscountDao.updateStatus(orderDiscountQuery);
        log.info("[订单优惠服务] 修改优惠状态完成，orderNum：{}", discountRequest.getOrderNum());

        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse<Map<String, String>> findDiscountNos(String tradeNo, Long parkId) {
        OrderDiscount orderDiscount = new OrderDiscount();
        orderDiscount.setTradeNo(tradeNo);
        orderDiscount.setParkId(parkId);
        List<OrderDiscount> orderDiscounts = _findList(orderDiscount);

        if (orderDiscounts.size() > 0){

            String discountNos = StrUtil.join(",",orderDiscounts.stream().map(OrderDiscount::getDiscountNo).collect(Collectors.toList()));
            Map<String, String> map = new HashMap<>();
            map.put("discountNos", discountNos);
            return ObjectResponse.success(map);
        }else{
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    public ObjectResponse<OrderDiscount> findOne(OrderDiscount orderDiscount) {
        if (orderDiscount.getId() == null) {
            orderDiscount.setDelFlag(0);
        }
        return ObjectResponse.returnNotFoundIfNull(orderDiscountDao.selectLimitOne(orderDiscount));
    }

    @Override
    public ObjectResponse<Long> addDiscount(OrderDiscount orderDiscount) {
        //默认为1
        orderDiscount.setCarStatus(1);
        int n = orderDiscountDao.insert(orderDiscount);
        if (n == 0){
            return ObjectResponse.failed(CodeConstants.ERROR_402);
        }else{
            return ObjectResponse.success(orderDiscount.getId());
        }
    }

    @Override
    @Transactional(rollbackFor =  Exception.class)
    public ObjectResponse<Boolean> addDiscounts(List<OrderDiscount> orderDiscounts) {
        int count = orderDiscountDao.saveBatch(orderDiscounts);
        if (count > 0) {
            return ObjectResponse.success(Boolean.TRUE);
        }
        return ObjectResponse.success(Boolean.FALSE);
    }

    @Override
    public ObjectResponse<List<OrderDiscount>> findList(OrderDiscount orderDiscount){
        PageQuery<OrderDiscount> pageQuery = new PageQuery<OrderDiscount>();
        pageQuery.setParam(orderDiscount);
        List<OrderDiscount> orderDiscounts = orderDiscountDao.selectListByPage(pageQuery);
        return ObjectResponse.success(orderDiscounts);
    }

    @Override
    public ObjectResponse<Double> getSumDiscount(Long parkId, String orderNum, Integer from, Integer status) {
        Double sumDiscount = orderDiscountDao.sumDiscount(orderNum, parkId, from, status);
        return ObjectResponse.success(sumDiscount);
    }

    /**
     * 更新优惠券信息
     * @param orderDiscount
     * @return
     */
    @Override
    public ObjectResponse updateDiscount(OrderDiscount orderDiscount) {
        int n = orderDiscountDao.updateById(orderDiscount);
        if (n == 0){
            return ObjectResponse.failed(CodeConstants.ERROR_402);
        }else{
            return ObjectResponse.success();
        }
    }

    @Override
    public ObjectResponse<OrderDiscount> findOneByPlateNum(Long parkId, String plateNum) {
        OrderDiscount orderDiscount = new OrderDiscount();
        orderDiscount.setParkId(parkId);
        orderDiscount.setPlateNum(plateNum);
        orderDiscount.setDelFlag(0);

        OrderDiscount orderDiscount1 =
                orderDiscountDao.selectOne(Wrappers.lambdaQuery(orderDiscount)
                        .orderByDesc(OrderDiscount::getId)
                        .last(SqlConstant.LIMIT_ONE));
        return ObjectResponse.returnNotFoundIfNull(orderDiscount1);
    }

    @Override
    @DS_SLAVE
    public ObjectResponse<com.icetech.common.domain.Page<OrderDiscount>> getOrderDiscountList(Long parkId, QueryDiscountRequest request) {

        Page<OrderDiscount> orderDiscountPage = orderDiscountDao.selectPage(
                Wrappers.lambdaQuery(OrderDiscount.class)
                        .eq(OrderDiscount::getParkId, parkId)
                        .eq(StringUtils.isNotEmpty(request.getOrderNum()),OrderDiscount::getOrderNum,request.getOrderNum())
                        .eq(StringUtils.isNotEmpty(request.getTradeNo()),OrderDiscount::getTradeNo,request.getTradeNo())
                        .eq(StringUtils.isNotEmpty(request.getDiscountNo()),OrderDiscount::getDiscountNo,request.getDiscountNo())
                        .eq(OrderDiscount::getDelFlag,0)
                        .gt(OrderDiscount::getSendTime, request.getStartTime())
                        .lt(OrderDiscount::getSendTime, request.getEndTime())
                        .orderByDesc(OrderDiscount::getSendTime)
                , request.getPageNo(), request.getPageSize());
        return ObjectResponse.success(com.icetech.common.domain.Page.instance(Math.toIntExact(orderDiscountPage.getPages()),orderDiscountPage.getTotal(),orderDiscountPage.getRecords()));
    }

    @Override
    public ObjectResponse<Integer> countNumByOrderNum(String orderNum, Long parkId) {
        Integer count = orderDiscountDao.selectCount(Wrappers.lambdaQuery(OrderDiscount.class)
                .eq(OrderDiscount::getOrderNum, orderNum)
                .eq(OrderDiscount::getDelFlag,0)
                .eq(OrderDiscount::getParkId, parkId));
        return ObjectResponse.success(count);
    }

    @Override
    @Transactional
    public ObjectResponse<Integer> cancelDiscount(Long id, Long parkId) {
        OrderDiscount orderDiscount = new OrderDiscount();
        orderDiscount.setId(id);
        orderDiscount.setDelFlag(1);
        int i = orderDiscountDao.updateById(orderDiscount);
        if (i > 0) {
            ObjectResponse<ParkConfig> objectResponse = parkService.getParkConfig(parkId);
            ObjectResponse.notError(objectResponse);
            Integer dataCollection = objectResponse.getData().getDataCollection();
            if (DataCollectionEnum.端网云.getType().equals(dataCollection)) {
                sendinfoDao.insert(new SendInfo(parkId, id, DownServiceEnum.撤销优惠下发.getServiceType()));
            }
        }
        return ObjectResponse.success(i);
    }

    @Override
    public List<OrderDiscount> findDiscountByOrderNum(List<String> orderNums, Integer status) {
        return orderDiscountDao.selectDiscountByOrderNum(orderNums, status);
    }

    @Override
    public List<DiscountDto> findList(DiscountDto dto) {
        PageHelper.startPage(NumberUtils.toPrimitive(dto.getPageNo(), 1),
                NumberUtils.toPrimitive(dto.getPageSize(), 10));
        return orderDiscountDao.selectListDiy(dto);
    }
    @Override
    public DiscountDto findOne(Long id) {
        if (id == null) {
            return null;
        }
        DiscountDto dto = new DiscountDto();
        dto.setId(id);
        List<DiscountDto> discountDtos = orderDiscountDao.selectListDiy(dto);
        if (CollectionUtils.isEmpty(discountDtos)) {
            return null;
        }
        return discountDtos.get(0);
    }

    @Override
    public String findMerchantName(Long parkId, String discountNo, String orderNum) {
        return orderDiscountDao.selectMerchantName(parkId, discountNo, orderNum);
    }

    public List<OrderDiscount> _findList(OrderDiscount orderDiscount){
        PageQuery<OrderDiscount> pageQuery = new PageQuery<>();
        pageQuery.setParam(orderDiscount);
        return orderDiscountDao.selectListByPage(pageQuery);

    }

}
