package com.icetech.order.service.impl;

import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.icetech.basics.sentinel.ExceptionUtils;
import com.icetech.cloudcenter.api.order.OrderAuthService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.request.OrderAuthQueryRequest;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.third.anno.DS_SLAVE;
import com.icetech.cloudcenter.domain.response.OrderAuthDto;
import com.icetech.order.dao.OrderAuthDao;
import com.icetech.basics.dao.park.ParkDao;
import com.icetech.basics.dao.park.ParkInoutdeviceDao;
import com.icetech.order.domain.entity.OrderAuthInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.oss.OssService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.*;

import javax.annotation.Resource;

@Slf4j
@Service
public class OrderAuthServiceImpl implements OrderAuthService {
    @Autowired
    private ParkDao parkDao;
    @Autowired
    private ParkInoutdeviceDao parkInoutdeviceDao;
    @Autowired
    private OrderAuthDao orderAuthDao;
    @Resource
    private OrderCarInfoDao orderCarInfoDao;
    @Autowired
    private ParkService parkService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OssService ossService;


    @Override
    public ObjectResponse upOrderAuth(OrderAuthInfo orderAuthInfo) {
        OrderAuthInfo orderAuthInfo1 = orderAuthDao.selectByAuthNum(orderAuthInfo.getAuthNum());
        if (orderAuthInfo1 != null) {
            if (StringUtils.isNotEmpty(orderAuthInfo.getOperAccount())) {
                String operAccount = orderAuthInfo1.getOperAccount();
                operAccount = operAccount + " | " + orderAuthInfo.getOperAccount();
                orderAuthInfo1.setOperAccount(operAccount);
            }
            orderAuthInfo1.setRemark(orderAuthInfo.getRemark());
            orderAuthInfo1.setUpPrice(orderAuthInfo.getUpPrice());
            orderAuthInfo1.setStatus(orderAuthInfo.getStatus());
            orderAuthInfo1.setAuthStatus(orderAuthInfo.getAuthStatus());
            orderAuthInfo1.setUpdateTime(new Date());
            orderAuthDao.updateOrderAuth(orderAuthInfo1);
        }
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse addOrderAuth(OrderAuthInfo orderAuthInfo) {
        String authNum = "A" + System.currentTimeMillis();
        orderAuthInfo.setAuthNum(authNum);
        orderAuthDao.insert(orderAuthInfo);
        Map<String, Object> map = new HashMap<>();
        map.put("authNum", authNum);
        return ObjectResponse.success(map);
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderAuthService.selectOrderByAuthNum", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<OrderAuthDto> selectOrderByAuthNum(String authNum) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        OrderAuthInfo orderAuthInfo = orderAuthDao.selectByAuthNum(authNum);
        OrderAuthDto orderAuthDto = new OrderAuthDto();
        orderAuthDto.setId(orderAuthInfo.getId());
        orderAuthDto.setRemark(orderAuthInfo.getRemark());
        orderAuthDto.setAuthNum(orderAuthInfo.getAuthNum());
        if (orderAuthInfo.getCreateTime() != null) {
            orderAuthDto.setApplyTime(sf.format(orderAuthInfo.getCreateTime()));
        }
        if (orderAuthInfo.getUpdateTime() != null) {
            orderAuthDto.setAnswerTime(sf.format(orderAuthInfo.getUpdateTime()));
        }
        orderAuthDto.setTotalPrice(orderAuthInfo.getTotalPrice());
        orderAuthDto.setUpPrice(orderAuthInfo.getUpPrice());
        orderAuthDto.setOperAccount(orderAuthInfo.getOperAccount());
        orderAuthDto.setStatus(orderAuthInfo.getStatus());
        Park park = parkService.findByParkId(Long.valueOf(orderAuthInfo.getParkId())).getData();
        if(!Objects.isNull(park)){
            orderAuthDto.setParkName(park.getParkName());
        }
        ParkInoutdevice parkInoutdevice = parkService.getInoutDeviceById(Long.valueOf(orderAuthInfo.getInandoutId())).getData();
        if(!Objects.isNull(parkInoutdevice)){
            orderAuthDto.setAisleName(parkInoutdevice.getInandoutName());
        }
        ObjectResponse<OrderInfo> byOrderNum = orderService.findByOrderNum(orderAuthInfo.getOrderNum());
        if(!Objects.isNull(byOrderNum.getData())){
            orderAuthDto.setPlateNum(byOrderNum.getData().getPlateNum());
            OrderCarInfo carInfo = orderCarInfoDao.selectByOrderNum(byOrderNum.getData().getOrderNum());
            if (carInfo != null) {
                String imageUrl = ossService.getImageUrl(carInfo.getEnterImage());
                orderAuthDto.setImage(imageUrl);
            }
        }
        orderAuthDto.setAuthStatus(orderAuthInfo.getAuthStatus());

        return ObjectResponse.success(orderAuthDto);
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderAuthService.selectOrderByOrderNum", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<OrderAuthDto> selectOrderByOrderNum(String orderNum, Integer status) {
        OrderAuthInfo orderAuthInfo = orderAuthDao.selectByOrderNum(orderNum, status);
        if (orderAuthInfo != null) {
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            OrderAuthDto orderAuthDto = new OrderAuthDto();
            orderAuthDto.setId(orderAuthInfo.getId());
            orderAuthDto.setRemark(orderAuthInfo.getRemark());
            orderAuthDto.setAuthNum(orderAuthInfo.getAuthNum());
            if (orderAuthInfo.getCreateTime() != null) {
                orderAuthDto.setApplyTime(sf.format(orderAuthInfo.getCreateTime()));
            }
            if (orderAuthInfo.getUpdateTime() != null) {
                orderAuthDto.setAnswerTime(sf.format(orderAuthInfo.getUpdateTime()));
            }
            orderAuthDto.setTotalPrice(orderAuthInfo.getTotalPrice());
            orderAuthDto.setUpPrice(orderAuthInfo.getUpPrice());
            Park park = parkService.findByParkId(Long.valueOf(orderAuthInfo.getParkId())).getData();
            orderAuthDto.setParkName(park.getParkName());
            orderAuthDto.setOperAccount(orderAuthInfo.getOperAccount());
            orderAuthDto.setStatus(orderAuthInfo.getStatus());
            ParkInoutdevice parkInoutdevice = parkService.getInoutDeviceById(Long.valueOf(orderAuthInfo.getInandoutId())).getData();
            orderAuthDto.setAisleName(parkInoutdevice.getInandoutName());
            ObjectResponse<OrderInfo> byOrderNum = orderService.findByOrderNum(orderAuthInfo.getOrderNum());
            orderAuthDto.setPlateNum(byOrderNum.getData().getPlateNum());
            orderAuthDto.setAuthStatus(orderAuthInfo.getAuthStatus());
            OrderCarInfo carInfo = orderCarInfoDao.selectByOrderNum(byOrderNum.getData().getOrderNum());
            if (carInfo != null) {
                String imageUrl = ossService.getImageUrl(carInfo.getEnterImage());
                orderAuthDto.setImage(imageUrl);
            }
            return ObjectResponse.success(orderAuthDto);
        }
        return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);

    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderAuthService.getOrderAuthList", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<List<OrderAuthDto>> getOrderAuthList(OrderAuthQueryRequest orderAuthQueryRequest) {
        String parkCodes = orderAuthQueryRequest.getParkCode();
        List<Integer> status = orderAuthQueryRequest.getStatus();
        Date endTime = orderAuthQueryRequest.getEndTime();
        Date startTime = orderAuthQueryRequest.getStartTime();
        String[] split = parkCodes.split(",");
        String parkids = parkDao.selectByCodes(split);
        PageHelper.startPage(orderAuthQueryRequest.getPageNo(), orderAuthQueryRequest.getPageSize());
        //查询在场记录信息
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List<OrderAuthInfo> records = orderAuthDao.selectAuthRecords(parkids,
                Objects.isNull(startTime) ? null : sf.format(startTime), Objects.isNull(endTime) ? null : sf.format(endTime), status);
        //封装返回数据
        List<OrderAuthDto> enterCarDtos = Lists.newArrayList();

        for (OrderAuthInfo orderAuthInfo : records) {
            OrderAuthDto orderAuthDto = new OrderAuthDto();
            orderAuthDto.setId(orderAuthInfo.getId());
            orderAuthDto.setRemark(orderAuthInfo.getRemark());
            orderAuthDto.setAuthNum(orderAuthInfo.getAuthNum());
            if (orderAuthInfo.getCreateTime() != null) {
                orderAuthDto.setApplyTime(sf.format(orderAuthInfo.getCreateTime()));
            }
            if (orderAuthInfo.getUpdateTime() != null) {
                orderAuthDto.setAnswerTime(sf.format(orderAuthInfo.getUpdateTime()));
            }
            orderAuthDto.setTotalPrice(orderAuthInfo.getTotalPrice());
            orderAuthDto.setUpPrice(orderAuthInfo.getUpPrice());
            Park park = parkService.findByParkId(Long.valueOf(orderAuthInfo.getParkId())).getData();
            orderAuthDto.setParkName(park.getParkName());
            orderAuthDto.setOperAccount(orderAuthInfo.getOperAccount());
            orderAuthDto.setStatus(orderAuthInfo.getStatus());
            orderAuthDto.setAuthStatus(orderAuthInfo.getAuthStatus());
            if (orderAuthInfo.getInandoutId() != null) {
                ParkInoutdevice parkInoutdevice = parkService.getInoutDeviceById(Long.valueOf(orderAuthInfo.getInandoutId())).getData();
                orderAuthDto.setAisleName(parkInoutdevice.getInandoutName());
            }
            ObjectResponse<OrderInfo> byOrderNum = orderService.findByOrderNum(orderAuthInfo.getOrderNum());
            if(ObjectResponse.isSuccess(byOrderNum)){
                OrderInfo data = byOrderNum.getData();
                orderAuthDto.setPlateNum(data.getPlateNum());
                Long enterTime = data.getEnterTime();
                if(!Objects.isNull(data.getExitTime())){
                    orderAuthDto.setParkTime(data.getExitTime() - enterTime);
                }else{
                    orderAuthDto.setParkTime(System.currentTimeMillis()/1000 - enterTime);
                }
                orderAuthDto.setParkTimeStr(DateTools.secondToSecondsTime(orderAuthDto.getParkTime().intValue()));
            }
            enterCarDtos.add(orderAuthDto);
        }
        return ObjectResponse.success(enterCarDtos);
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderAuthService.countOrderAuthList", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse countOrderAuthList(OrderAuthQueryRequest orderAuthQueryRequest) {
        String parkCode = orderAuthQueryRequest.getParkCode();
        Date startTime = orderAuthQueryRequest.getStartTime();
        Date endTime = orderAuthQueryRequest.getEndTime();
        List<Integer> status = orderAuthQueryRequest.getStatus();
        String[] split = parkCode.split(",");
        String parkids = parkDao.selectByCodes(split);
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int count = orderAuthDao.countAuthRecords(parkids,
                Objects.isNull(startTime) ? null : sf.format(startTime), Objects.isNull(endTime) ? null : sf.format(endTime), status);
        Map<String, Object> map = new HashMap<>();
        map.put("count", count);
        return ObjectResponse.success(map);
    }
}
