package com.icetech.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.icetech.common.domain.Page;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.order.dao.BarrierGateExceptionMapper;
import com.icetech.order.domain.dto.BarrierGateExceptionDTO;
import com.icetech.order.domain.entity.BarrierGateException;
import com.icetech.order.domain.entity.OrderBack;
import com.icetech.order.service.BarrierGateExceptionService;
import com.icetech.third.service.third.MqPushService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * 道闸异常记录表 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2023-08-01
 */
@Service
public class BarrierGateExceptionServiceImpl extends BaseServiceImpl<BarrierGateExceptionMapper, BarrierGateException> implements BarrierGateExceptionService {
    @Autowired
    private MqPushService mqPushService;

    /**
     * Description: 根据ID查询 道闸异常记录表对象信息 <br>
     * Version1.0 2023-08-01 by wangzhiwei创建
     *
     * @param id 对象id
     * @return BarrierGateException
     */
    @Override
    public BarrierGateException getBarrierGateExceptionById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  道闸异常记录表对象信息 <br>
     * Version1.0 2023-08-01 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addBarrierGateException (BarrierGateException entity) {
        boolean result = save(entity);
        mqPushService.pushBarrierGateException(entity);
        return result;
    }

    /**
     * Description: 修改 道闸异常记录表对象信息 <br>
     * Version1.0 2023-08-01 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyBarrierGateException (BarrierGateException entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  道闸异常记录表对象信息 <br>
     * Version1.0 2023-08-01 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeBarrierGateExceptionById (Long id) {
        return removeById(id);
    }

    @Override
    public Page<BarrierGateException> getPageList(BarrierGateExceptionDTO queryDTO, List<Long> parkIds) {
        QueryWrapper<BarrierGateException> wrapper = new QueryWrapper<>();
        if (CollectionUtils.isNotEmpty(parkIds)){
            wrapper.in(org.apache.commons.collections4.CollectionUtils.isNotEmpty(parkIds) && !parkIds.contains(-1L),"park_id",parkIds);
        }
        wrapper.between(Objects.nonNull(queryDTO.getStartDate()) && Objects.nonNull(queryDTO.getEndDate()),"create_time",queryDTO.getStartDate(),queryDTO.getEndDate());
        wrapper.orderByDesc("id");
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<BarrierGateException> page = page(wrapper, queryDTO.getPageNo(), queryDTO.getPageSize());

        return Page.instance(Math.toIntExact(page.getPages()),page.getTotal(),page.getRecords());
    }

}
