package com.icetech.order.service;


import com.icetech.common.domain.Page;
import com.icetech.db.mybatis.base.service.IBaseService;
import com.icetech.park.domain.entity.ShamPlate;

import java.util.List;

/**
 * 虚假车牌记录表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @date 2023-07-20
 */
public interface ShamPlateService extends IBaseService<ShamPlate> {

    /**
     * Description: 根据ID查询 虚假车牌记录表对象信息 <br>
     * Version1.0 2023-07-20 by fangct创建
     *
     * @param id 对象id
     * @return ShamPlate
     */
    ShamPlate getShamPlateById (Long id);

    /**
     * Description: 新增  虚假车牌记录表对象信息 <br>
     * Version1.0 2023-07-20 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addShamPlate (ShamPlate entity);

    /**
     * Description: 修改 虚假车牌记录表对象信息 <br>
     * Version1.0 2023-07-20 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyShamPlate (ShamPlate entity);

    /**
     * Description: 删除  虚假车牌记录表对象信息 <br>
     * Version1.0 2023-07-20 by fangct创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeShamPlateById (Long id);

    /**
     * 虚假车牌分页
     *
     * @param pageNo
     * @param pageSize
     * @param plateNum
     * @param parkIds
     * @param startTime
     * @param endTime
     * @return
     */
    Page<ShamPlate> getPage(Integer pageNo, Integer pageSize, String plateNum, List<Long> parkIds, String startTime, String endTime);

    /**
     * 没有开通返回数量
     * @param plateNum
     * @param parkIds
     * @param startTime
     * @param endTime
     * @return
     */
    Long getTotal(String plateNum, List<Long> parkIds, String startTime, String endTime);

    /**
     * 通过id或者订单号获取虚假车牌
     *
     * @param id
     * @param orderNum
     * @return
     */
    ShamPlate getShamPlateBy(Long id, String orderNum);

    /**
     * 通过订单号获取虚假车牌列表
     *
     * @param orderNum
     * @return
     */
    List<ShamPlate> getShamPlateListByOrderNum (String orderNum);
}
