package com.icetech.order.service;

import com.icetech.order.domain.entity.OrderTags;
import com.icetech.db.mybatis.base.service.IBaseService;

import java.util.List;

/**
 * 订单标签关联表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @date 2021-11-10
 */
public interface OrderTagsService extends IBaseService<OrderTags> {

    /**
     * Description: 根据orderNum查询 订单标签关联表对象信息 <br>
     * Version1.0 2021-11-10 by fangct创建
     *
     * @param orderNum 订单号
     * @return OrderTags
     */
    OrderTags getListByOrderNumAndTagId(String orderNum, Integer tagId, Long regionId);
    /**
     * Description: 根据ID查询 订单标签关联表对象信息 <br>
     * Version1.0 2021-11-10 by fangct创建
     *
     * @param id 对象id
     * @return OrderTags
     */
    OrderTags getOrderTagsById (Long id);

    /**
     * Description: 新增  订单标签关联表对象信息 <br>
     * Version1.0 2021-11-10 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addOrderTags (OrderTags entity);

    /**
     * Description: 修改 订单标签关联表对象信息 <br>
     * Version1.0 2021-11-10 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyOrderTags (OrderTags entity);

    /**
     * Description: 删除  订单标签关联表对象信息 <br>
     * Version1.0 2021-11-10 by fangct创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeOrderTagsById (Long id);

    /**
     * 通过订单号获取标签列表
     *
     * @param orderNum
     * @param type 0:欠费追缴;1非欠费追缴
     * @return
     */
    List<OrderTags> getListByOrderNum(String orderNum, Integer type);

}
