package com.icetech.order.service;

import com.icetech.common.domain.Page;
import com.icetech.order.domain.dto.NotPayAccountQueryDTO;
import com.icetech.order.domain.entity.OrderNotpaySubaccount;
import com.icetech.db.mybatis.base.service.IBaseService;

/**
 * 欠费追缴费用分账明细 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @date 2023-11-07
 */
public interface OrderNotpaySubaccountService extends IBaseService<OrderNotpaySubaccount> {

    /**
     * Description: 根据ID查询 欠费追缴费用分账明细对象信息 <br>
     * Version1.0 2023-11-07 by fangct创建
     *
     * @param id 对象id
     * @return OrderNotpaySubaccount
     */
    OrderNotpaySubaccount getOrderNotpaySubaccountById (Long id);

    /**
     * Description: 新增  欠费追缴费用分账明细对象信息 <br>
     * Version1.0 2023-11-07 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addOrderNotpaySubaccount (OrderNotpaySubaccount entity);

    /**
     * Description: 修改 欠费追缴费用分账明细对象信息 <br>
     * Version1.0 2023-11-07 by fangct创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyOrderNotpaySubaccount (OrderNotpaySubaccount entity);

    /**
     * Description: 删除  欠费追缴费用分账明细对象信息 <br>
     * Version1.0 2023-11-07 by fangct创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeOrderNotpaySubaccountById (Long id);

    /**
     * 获取分页信息
     *
     * @param queryDTO
     * @return
     */
    Page<OrderNotpaySubaccount> getNotPaySubAccountPage(NotPayAccountQueryDTO queryDTO);

    /**
     * 查询总的费用
     * @param queryDTO
     * @return
     */
    OrderNotpaySubaccount totalMoney(NotPayAccountQueryDTO queryDTO);
}
