package com.icetech.order.service;

import com.icetech.common.domain.Page;
import com.icetech.db.mybatis.base.service.IBaseService;
import com.icetech.order.domain.dto.BarrierGateExceptionDTO;
import com.icetech.order.domain.entity.BarrierGateException;

import java.util.List;

/**
 * 道闸异常记录表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2023-08-01
 */
public interface BarrierGateExceptionService extends IBaseService<BarrierGateException> {

    /**
     * Description: 根据ID查询 道闸异常记录表对象信息 <br>
     * Version1.0 2023-08-01 by wangzhiwei创建
     *
     * @param id 对象id
     * @return BarrierGateException
     */
    BarrierGateException getBarrierGateExceptionById (Long id);

    /**
     * Description: 新增  道闸异常记录表对象信息 <br>
     * Version1.0 2023-08-01 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addBarrierGateException (BarrierGateException entity);

    /**
     * Description: 修改 道闸异常记录表对象信息 <br>
     * Version1.0 2023-08-01 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyBarrierGateException (BarrierGateException entity);

    /**
     * Description: 删除  道闸异常记录表对象信息 <br>
     * Version1.0 2023-08-01 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeBarrierGateExceptionById (Long id);

    /**
     * 分页获取记录
     * @param queryDTO
     * @param parkIds
     * @return
     */
    Page<BarrierGateException> getPageList(BarrierGateExceptionDTO queryDTO, List<Long> parkIds);
}
