package com.icetech.order.dao;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.icetech.cloudcenter.domain.order.OrderRefundDto;
import com.icetech.db.mybatis.base.mapper.SuperMapper;
import com.icetech.order.domain.dto.OrderRefundDTO;
import com.icetech.order.domain.entity.OrderRefund;
import com.icetech.park.domain.request.RefundParam;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;


/**
 * 退款订单表 Mapper 接口
 */
@Repository
public interface OrderRefundDao extends SuperMapper<OrderRefund> {

    /**
     * 插入数据
     *
     * @param refund 实体对象
     * @return int
     */
    int insert(OrderRefund refund);

    /**
     * 插叙退款订单列表
     *
     * @param page  分 页
     * @param param 参数
     * @return list
     */
    Page<OrderRefundDTO> getOrderRefundList(@Param("page") Page<OrderRefundDTO> page, @Param("param") RefundParam param);

    /**
     * 插叙退款订单列表
     *
     * @param param 参数
     * @return list
     */
    Map<String, BigDecimal> sumRefundPrice(@Param("param") RefundParam param);

    /**
     * 查询电子支付订单
     *
     * @param orderNum 订单号
     * @return list
     */
    List<OrderRefund> selectList(@Param("orderNum") String orderNum);

}