package com.icetech.order.dao;

import com.icetech.cloudcenter.domain.response.OrderDiscountDto;
import com.icetech.cloudcenter.domain.order.query.OrderDiscountQuery;
import com.icetech.order.domain.dto.DiscountDto;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.common.domain.response.PageQuery;
import com.icetech.db.mybatis.base.mapper.SuperMapper;
import com.icetech.park.domain.vo.FindDiscountVo;
import com.icetech.third.anno.DS_SLAVE;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;

/**
 * Description : 订单优惠表操作DAO
 *
 * @author fangct
 */
@Repository
public interface OrderDiscountDao extends SuperMapper<OrderDiscount> {
    /**
     * 分页查询结果集
     *
     * @param query
     * @return
     */
    List<OrderDiscount> selectListByPage(PageQuery<OrderDiscount> query);

    /**
     * 修改优惠状态
     *
     * @param orderDiscountQuery
     * @return
     */
    int updateStatus(OrderDiscountQuery orderDiscountQuery);

    /**
     * 按时间查询已经发放的优惠券记录
     *
     * @param vo
     * @return
     */
    List<OrderDiscountDto> findDiscountRecords(@Param("vo") FindDiscountVo vo);

    /**
     * 根据订单号查询
     *
     * @param orderNum
     * @return
     */
    List<OrderDiscount> selectByOrderNum(@Param("orderNum") String orderNum, @Param("status") Integer status);

    /**
     * 查询某种类型的优惠
     *
     * @param orderNum
     * @return
     */
    List<OrderDiscount> selectByType(@Param("orderNum") String orderNum, @Param("parkId") Long parkId, @Param("type") Integer type, @Param("status") Integer status);

    /**
     * 汇总优惠
     *
     * @param orderNum
     * @param parkId
     * @param from
     * @param status
     * @return
     */
    Double sumDiscount(@Param("orderNum") String orderNum, @Param("parkId") Long parkId, @Param("from") Integer from, @Param("status") Integer status);

    OrderDiscount findByPlateAndDisId(@Param("parkId") Long parkId, @Param("plateNum") String plateNum, @Param("disId") Long disId);

    OrderDiscount findLastDiscountByPlateAndOnceDay(@Param("parkId") Long parkId, @Param("plateNum") String plateNum);

    /**
     * 查询过期优惠列表
     *
     * @return
     */
    @DS_SLAVE
    List<OrderDiscount> selectExpireList();

    /**
     * 查询离场后但未使用的优惠券
     *
     * @param refundTime 退费时间
     * @return 优惠列表
     */
    List<OrderDiscount> selectExitAndNoUseList(String refundTime);

    /**
     * 根据订单号查询优惠券
     *
     * @param orderNums 订单号列表
     * @param status    优惠券状态
     * @return 优惠券列表
     */
    List<OrderDiscount> selectDiscountByOrderNum(@Param("orderNums") List<String> orderNums, @Param("status") Integer status);

    /**
     * 查询商户名称
     *
     * @param parkId     车场ID
     * @param discountNo 优惠编号
     * @param orderNum   订单号
     * @return 商户名称
     */
    String selectMerchantName(@Param("parkId") Long parkId, @Param("discountNo") String discountNo, @Param("orderNum") String orderNum);

    /**
     * 查询优惠记录列表
     *
     * @param dto 参数
     * @return 结果集
     */
    List<DiscountDto> selectListDiy(DiscountDto dto);


    /**
     * 批量添加优惠
     * @param orderDiscounts
     * @return
     */
    int saveBatch(List<OrderDiscount> orderDiscounts);
}
