package com.icetech.order.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.icetech.excel.anno.ExcelDictFormat;
import com.icetech.excel.convert.ExcelDictConvert;
import com.icetech.excel.convert.TimestampSecondStringConverter;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;

/**
 * 支付明细优惠统计列表数据
 * @author fangct
 */
@ExcelIgnoreUnannotated
@Getter
@Setter
@ToString
public class PayDiscountListVo {
    private Long id;

    @ExcelProperty(value = "车场名称")
    private String parkName;
    @ExcelProperty(value = "车牌号")
    private String plateNum;
    @ExcelProperty(value = "车辆类型",converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "1=临时车,2=月卡车,3=特殊车辆,4=VIP车辆,5=访客车辆,6=储值卡车")
    private Integer type;
    @ExcelProperty(value = "入场时间",converter = TimestampSecondStringConverter.class)
    private Long enterTime;
    private Long exitTime;

    @ExcelProperty(value = "支付时间",converter = TimestampSecondStringConverter.class)
    private Long payTime;

    private Long parkTime;
    @ExcelProperty(value = "计费时长")
    private String parkingTimeStr;

    @ExcelProperty(value = "应收金额")
    private BigDecimal totalPrice;
    @ExcelProperty(value = "实收金额")
    private BigDecimal paidPrice;
    @ExcelProperty(value = "优惠金额")
    private BigDecimal discountPrice;
    @ExcelProperty(value = "商户端优惠")
    private BigDecimal merchantDiscountPrice;
    @ExcelProperty(value = "第三方优惠")
    private BigDecimal thirdDiscountPrice;
    @ExcelProperty(value = "vip车辆抵扣优惠")
    private BigDecimal vipDiscountPrice;
    @ExcelProperty(value = "收费员免费放行优惠")
    private BigDecimal tollDiscountPrice;
}
