package com.icetech.order.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.TableField;
import com.icetech.order.domain.entity.OrderNotpay;
import com.icetech.order.domain.entity.OrderPay;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * Description OrderNotpayVO
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/3/27 14:14
 */
@Data
@ExcelIgnoreUnannotated
@AllArgsConstructor
@NoArgsConstructor
public class OrderNotpayVO extends OrderNotpay {

    /**
     * 车场编号
     */
    private String parkCode;
    /**
     * 车场名称
     */
    @ExcelProperty(value = "车场名称")
    private String parkName;
    /**
     * 入场图片
     */
    private String enterImg;
    /**
     * 离场图片
     */
    private String exitImg;
    /**
     * 是否有子区域 0：否，1：是，默认为0
     */
    private Integer hasSon;
    /**
     * 停车时长
     */
    @ExcelProperty(value = "停车时长")
    private String parkingTimeStr;

    /**
     * 订单表的ID
     */
    private Long orderId;

    /**
     * 报警位置
     */
    @ExcelProperty(value = "报警位置")
    private String warnChannelName;


    /** 是否存在场中场(0否，1是默认0) */
    protected Integer isInterior;

    /**
     * 是否加装监控相机，0：未装，1：已装
     */
    private Integer hasMorCamera = 0;
}
