package com.icetech.order.domain.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 计数签证官
 *
 * @author wangzhiwei
 * @date 2023/08/16
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CountVO implements Serializable {
    /**
     * 车辆数
     */
    private Integer totalNum =0;
    /**
     * 欠费金额
     */
    private BigDecimal totalPrice = BigDecimal.ZERO;

    /**
     * 补缴金额
     */
    private BigDecimal paidPrice = BigDecimal.ZERO;
}
