package com.icetech.order.domain.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * 场中场订单轨记表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @date 2022-08-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@Accessors(chain = true)
@TableName("ice_order_track")
public class OrderTrack implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 记录类型（1:进场;2:出场）
     */
    private Integer recordType;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 区域id
     */
    private Long regionId;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 进场/离场时间
     */
    private Long enexTime;

    /**
     * 车辆类型(1临时车2月卡车3特殊车辆 4VIP车辆 5访客车辆 6储值卡车，默认1)
     */
    private Integer type;

    /**
     * 通道名称（进出口名称）
     */
    private String channelName;

    /**
     * 进出场景图片
     */
    private String image;

    /**
     * 入场方式：1车牌识别入场，2遥控器抬杆入场，3无牌车扫码入场，4软件人工入场
     */
    private Integer inoutEvent;

    /**
     * 操作员/收费员
     */
    private String operAccount;
    /**
     * 入场出场终端 1 云坐席、2 车场帮APP 、3 云岗亭、4岗亭计费软件、5 车场监控'
     */
    private Integer exTerminal;
    /**
     * 开闸原因，同订单表的异常离场原因
     */
    private Integer openReason;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;


}
