package com.icetech.order.domain.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.io.Serializable;

/**
 * 订单标签关联表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @date 2021-11-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Builder
@AllArgsConstructor
@NoArgsConstructor
@TableName("ice_order_tags")
public class OrderTags implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 订单号
     */
    private String orderNum;
    /**
     * 车场ID
     */
    private Long parkId;

    /**
     * 区域ID
     */
    private Long regionId;
    /**
     * 标签id，1：多位多车占用，2：使用该车上一次的入场时间计费，3：欠费车辆，4：折返回场，5：虚假车牌，6：补缴车辆
     */
    private Integer tagId;

    /**
     * 描述
     */
    private String remark;

    /**
     * 离场时间
     */
    private Long exitTime;

    public enum TagIdEnum {
        /**
         * 多位多车占用
         */
        AB_CAR(1),
        USE_LAST_EXIT_TIME(2),
        /** 未支付车辆/欠费车辆/跟车逃费 */
        NOT_PAY_CAR(3),
        BACK_IN_PARK(4),
        /** 虚假车牌 */
        SHAM_PLATE(5),
        BACK_PAY(6),
        ;
        @Getter
        private final int type;
        TagIdEnum(int type) {
            this.type = type;
        }
    }

}
