package com.icetech.order.domain.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 退款订单表 实体类
 */
@Data
@TableName("ice_order_refund")
public class OrderRefund implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 车场id
     */
    @TableField("park_id")
    private Long parkId;

    /**
     * 支付ID
     */
    @TableField("pay_id")
    private Long payId;
    /**
     * 车牌号
     */
    @TableField("plate_num")
    private String plateNum;
    /**
     * 车牌颜色
     */
    @TableField("plate_color")
    private String plateColor;
    /**
     * 车辆类型:1临时车2月卡车3特殊车辆
     */
    @TableField("car_type")
    private Integer carType;
    /**
     * 入场时间
     */
    @TableField("enter_time")
    private Long enterTime;
    /**
     * 离场时间
     */
    @TableField("exit_time")
    private Long exitTime;
    /**
     * 订单号
     */
    @TableField("order_num")
    private String orderNum;
    /**
     * '缴费渠道1本地出口支付,2 H5扫码支付,3自助缴费机,4中央收费站,5第三方,6运维管理APP,7免密支付,8停车机器人,9公众号缴费,10遥控器',
     */
    @TableField("pay_channel")
    private Integer payChannel;
    /**
     * 退款金额
     */
    @TableField("refund_price")
    private BigDecimal refundPrice;
    /**
     * 实退金额
     */
    @TableField("actual_refund_price")
    private BigDecimal actualRefundPrice;
    /**
     * 退款状态 -1=已取消 0= 待审核 1=未退款 2=退款中 3=退款成功 4=退款失败
     */
    @TableField("refund_status")
    private Integer refundStatus;
    /**
     * 退款原因
     */
    @TableField("refund_reason")
    private String refundReason;
    /**
     * 退款失败原因
     */
    @TableField("refund_fail_msg")
    private String refundFailMsg;
    /**
     * 终端流水号
     */
    @TableField("trace_no")
    private String traceNo;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;
    /**
     * 删除标识:0未删除;1已删除
     */
    @TableField("deleted")
    private Integer deleted;
}