package com.icetech.order.domain.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * Description : 订单交易信息表实体
 * @author fangct
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@TableName(value = "`ice_order_pay`")
public class OrderPay implements Serializable {
    /** 主键自增长id */
    @TableId(value = "`id`")
    protected Long id;
    /** 停车场id */
    @TableField(value = "`park_id`")
    protected Long parkId;
    /** 订单号 */
    @TableField(value = "`order_num`")
    protected String orderNum;
    /** 交易流水号 */
    @TableField(value = "`trade_no`")
    protected String tradeNo;
    /** 支付状态，1：支付中，2：已支付，3：取消 */
    @TableField(value = "`pay_status`")
    protected Integer payStatus;
    /** 退款状态   1=未退款 2=退款中 3=退款成功 4=退款失败 */
    @TableField(value = "`refund_status`")
    protected Integer refundStatus;
    /** 支付时间，年-月-日 时:分:秒 */
    @TableField(value = "`pay_date`")
    protected Date payDate;
    /** 下单时间 */
    @TableField(value = "`order_time`")
    protected Long orderTime;
    /** 支付时间 */
    @TableField(value = "`pay_time`")
    protected Long payTime;
    /** 应收金额 */
    @TableField(value = "`total_price`")
    protected String totalPrice;
    /** 实收金额 */
    @TableField(value = "`paid_price`")
    protected String paidPrice;
    /** 优惠金额 */
    @TableField(value = "`discount_price`")
    protected String discountPrice;
    /** 实际收钞 */
    @TableField(value = "`actual_cash`")
    protected String actualCash;
    /** 红包找零 */
    @TableField(value = "`redpack_ret`")
    protected String redpackRet;
    /** 缴费渠道1本地出口支付,2 H5扫码支付,3自助缴费机,4中央收费站,5第三方,6运维管理APP,7免密支付,8停车机器人,9公众号缴费,10遥控器 12.同程小程序*/
    @TableField(value = "`pay_channel`")
    protected Integer payChannel;
    /** 缴费终端（当缴费渠道是1时，此字段是出口名称； 当缴费渠道是3时，为自助缴费机编号;缴费渠道是4时,为收费站编号;缴费渠道是5时,为第三方名称） */
    @TableField(value = "`pay_terminal`")
    protected String payTerminal;
    /** 缴费方式1现金，2微信，3支付宝，4银联 6ETC 10优惠抵扣*/
    @TableField(value = "`pay_way`")
    protected Integer payWay;
    /** 支付通道1=微信直连 2=支付宝直连 3=建行 4=农行 5=云纵 6=阿里平台7=甘肃 8=福建 9=工商银行 10=兰州 11=广发 12=网联客 13=浙江农商行 14=光大银行 15=拉卡拉 16=广电运通,17=云南农信 */
    @TableField(value = "`pay_aisle`")
    protected Integer payAisle;
    /** 公众号用户的id */
    @TableField(value = "`mp_user_id`")
    protected Integer mpUserId;
    /** 缴费的通道id */
    @TableField(value = "`channel_id`")
    protected String channelId;
    /** 区域id */
    @TableField(value = "`region_id`")
    protected Integer regionId;
    /** 上次交费时间 */
    @TableField(value = "`last_pay_time`")
    protected Long lastPayTime;
    /** 收费员 */
    @TableField(value = "`user_account`")
    protected String userAccount;
    /** 是否需要下发，0：不需要，1：需要 */
    @TableField(value = "`is_sync`")
    protected Integer isSync;
    /** 是否开票0=未开票 1=已开票 */
    @TableField(value = "`is_invioce`")
    protected Integer isInvioce;
    /** 备注 */
    @TableField(value = "`remark`")
    protected String remark;
    /** 下单时间 */
    @TableField(value = "`create_time`")
    protected Date createTime;
    /** 储值卡扣除金额 */
    @TableField(value = "`balance_price`")
    protected BigDecimal balancePrice;
    /** 储值卡编号 */
    @TableField(value = "`card_num`")
    protected String cardNum;
    /** 是否通过城市大脑扣费 0=否 1=是 默认0 */
    @TableField(value = "`city_autopay`")
    protected Integer cityAutopay;
    /** 三方交易流水号 */
    @TableField(value = "`third_trade_no`")
    protected String thirdTradeNo;
    /** 银行侧交易流水号 */
    @TableField(value = "`bank_order_id`")
    protected String bankOrderId;
    /** 是否存在子支付订单 0/1 */
    @TableField(value="`is_son_orderpay`")
    protected Integer isSonOrderpay;
    /**
     * 缴费类型，1：补缴
     */
    @TableField(value="`pay_type`")
    protected Integer payType;
    /**
     * 支付明细信息
     */
    @TableField(exist = false)
    private List<OrderPayDetail> orderPayDetails;
    /**
     * 退款金额
     */
    @TableField(value="`refund_price`")
    private BigDecimal refundPrice;
    /**
     * 更新人
     */
    @TableField(value="`update_user`")
    private String updateUser;

    public void setPayTime(Long payTime) {
        this.payTime = payTime;
        if (payTime != null) {
            this.payDate = new Date(payTime * 1000);
        }
    }
}
