package com.icetech.order.domain.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 欠费追缴费用分账明细
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @date 2023-11-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@AllArgsConstructor
@TableName("ice_order_notpay_subaccount")
public class OrderNotpaySubaccount implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 交易流水号
     */
    private String tradeNo;

    /**
     * 商户交易流水号
     */
    private String thirdTradeNo;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 车辆类型(1临时车2月卡车3特殊车辆，默认1)
     */
    private Integer type;

    /**
     * 进场时间
     */
    private Long enterTime;

    /**
     * 离场时间
     */
    private Long exitTime;

    /**
     * 支付方式，1现金，2微信，3支付宝，4银联
     */
    private Integer payWay;

    /**
     * 支付时间
     */
    private Long payTime;

    /**
     * 补缴金额
     */
    private BigDecimal paidPrice;

    /**
     * 分账时间
     */
    private String divisionTime;

    /**
     * 平台分账比例
     */
    private BigDecimal divisionProfit;

    /**
     * 平台入账方收款金额
     */
    private BigDecimal platformAmount;

    /**
     * 车场收款金额
     */
    private BigDecimal parkAmount;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 删除标记，0：正常，1：删除
     */
    private Integer delFlag;


}
