package com.icetech.order.domain.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * 订单表
 * Description : 订单表实体
 *
 * @author fangct
 */
@Data
@TableName(value = "`ice_order`")
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class OrderInfo implements Serializable {
    /**
     * 主键自增长id
     */
    @TableId(value = "`id`")
    protected Long id;
    /**
     * 订单号
     */
    @TableField(value = "`order_num`")
    protected String orderNum;
    /**
     * 车场id
     */
    @TableField(value = "`park_id`")
    protected Long parkId;
    /**
     * 车牌号
     */
    @TableField(value = "`plate_num`")
    protected String plateNum;
    /**
     * 车辆类型(1临时车2月卡车3特殊车辆，默认1)
     */
    @TableField(value = "`type`")
    protected Integer type;
    /**
     * 区域id
     */
    @TableField(value = "`region_id`")
    protected Long regionId;
    /**
     * 是否有子订单，0：否，1：是，默认为0
     */
    @TableField(value = "`has_son`")
    protected Integer hasSon;
    /**
     * 进场时间
     */
    @TableField(value = "`enter_time`")
    protected Long enterTime;
    /**
     * 离场时间
     */
    @TableField(value = "`exit_time`")
    protected Long exitTime;
    /**
     * 车型(2大型车、1小型车，默认1)
     */
    @TableField(value = "`car_type`")
    protected Integer carType;
    /**
     * 总应收金额
     */
    @TableField(value = "`total_price`")
    protected String totalPrice;
    /**
     * 总实收金额
     */
    @TableField(value = "`paid_price`")
    protected String paidPrice;
    /**
     * 总优惠金额
     */
    @TableField(value = "`discount_price`")
    protected String discountPrice;
    /**
     * 订单状态（1在场2离场3已取消4异常记录）
     */
    @TableField(value = "`service_status`")
    protected Integer serviceStatus;
    /**
     * 订单状态为4时异常原因
     */
    @TableField(value = "`odd_status`")
    protected Integer oddStatus;
    /**
     * 操作员
     */
    @TableField(value = "`oper_account`")
    protected String operAccount;
    /**
     * 预交费时间
     */
    @TableField(value = "`prepay_time`")
    protected Long prepayTime;
    /**
     * 预交费实收金额
     */
    @TableField(value = "`prepay_amount`")
    protected String prepayAmount;
    /**
     * AB车切换时间
     */
    @TableField(value = "`switch_time`")
    protected Long switchTime;
    /**
     * 车辆描述
     */
    @TableField(value = "`car_desc`")
    protected String carDesc;
    /**
     * 去汉字车牌
     */
    @TableField(value = "`plate_num2`")
    protected String plateNum2;
    /**
     * 本地订单号
     */
    @TableField(value = "`local_order_num`")
    protected String localOrderNum;
    /**
     * 创建时间
     */
    @TableField(value = "`create_time`")
    protected Date createTime;
    /**
     * 储值卡扣除金额
     */
    @TableField(value = "`balance_price`")
    protected BigDecimal balancePrice;
    /**
     * 是否通过城市大脑扣费 0=否 1=是 默认0
     */
    @TableField(value = "`city_autopay`")
    protected Integer cityAutopay;
    /**
     * 待缴费金额，先离场后付费用
     */
    @TableField(value = "`need_price`")
    protected String needPrice;
    /**
     * 无入场记录标识(0=否;1=是)
     */
    @TableField(value = "`none_enter_flag`")
    protected Integer noneEnterFlag;
    /**
     * 入口通道ID
     */
    @TableField(value = "`enter_channel_id`")
    protected String enterChannelId;
    /**
     * 出口通道ID
     */
    @TableField(value = "`exit_channel_id`")
    protected String exitChannelId;
    /**
     * 退款金额
     */
    @TableField(value="`refund_price`")
    private BigDecimal refundPrice;

    /**
     * 退款金额
     */
    @TableField(value="`error_causes`")
    private String errorCauses;
}
