package com.icetech.order.domain.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Description: 欠费补缴的订单
 * @Author: fangct
 * @CreateTime: 2023-07-20  10:31
 * @Version: 1.0
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class OrderBackQueryDTO implements Serializable {

    /**
     * 车场编号
     */
    private String parkCode;
    /**
     * 车场ids
     */
    private List<Long> parkIds;
    /**
     * 车牌号
     */
    private String plateNum;
    /**
     * 订单编号
     */
    private String orderNum;
    /**
     * 通道类型 1 - 入口  2-出口
     */
    private Integer inandoutType;
    /**
     * 开始时间
     */
    @JsonFormat( pattern="yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date startDate;
    /**
     * 结束时间
     */
    @JsonFormat( pattern="yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date endDate;
    /**
     * 每页条数
     */
    private Integer pageSize = 10;
    /**
     * 页码
     */
    private Integer pageNo = 1;
    /**
     * 是否加载图片
     */
    private Boolean loadImage = true;
}
