package com.icetech.order.domain.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author wanggang
 * @create 2023-11-08 15:14
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class NotPayAccountQueryDTO implements Serializable {

    /**
     * 车场ids
     */
    private List<Long> parkIds;

    /**
     * 查询支付开始时间
     */
    private Long payStartTime;

    /**
     * 查询支付结束时间
     */
    private Long payEndTime;

    /**
     * 页码
     */
    private Integer pageNo = 1;

    /**
     * 分页大小
     */
    private Integer pageSize = 10;

}
