package com.icetech.order.domain.dto;

import com.icetech.common.annotation.NotNull;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 优惠记录查询参数和响应
 * @author fangct
 */
@Data
public class DiscountDto implements Serializable {

    //查询参数
    private Integer pageSize = 10;
    private Integer pageNo = 1;
    /**
     * 车场ID集合
     */
    private List<Long> parkIdList;
    /**
     * 商户名称
     */
    private String merchantName;
    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 开始时间
     */
    @NotNull
    private String startTime;

    /**
     * 结束时间
     */
    @NotNull
    private String endTime;

    /**
     * 优惠类型,1全免、2减免时间、3减免金额、4折扣、5按天优免
     */
    private List<Integer> typeList;

    /**
     * 状态列表，0未使用1已使用3已过期
     */
    private List<Integer> statusList;

    /**
     * 来源列表，0：本地优惠,1:商户端,2:第三方优惠
     */
    private List<Integer> fromList;
    /**
     * 车辆状态,1在场 2离场
     */
    private List<Integer> carStatusList;

    //响应参数
    private Long id;
    /**
     * 车场ID集合
     */
    private Long parkId;
    /**
     * 优惠券编号
     */
    private String discountNo;

    /**
     * 车场名称
     */
    private String parkName;
    /**
     * 优惠券名称
     */
    private String discountName;
    /**
     * 优惠面值
     */
    private String amount;
    /**
     * 优惠来源，0：本地优惠,1:商户端,2:第三方优惠
     */
    private Integer from;
    /**
     * 优惠类型,1全免券、2时长券、3代金券、4折扣券、5按天优免券
     */
    private Integer type;

    /**
     * 优惠券的结束时间
     */
    private String expireTime;
    /**
     * 优惠券状态，0未使用 1已使用 2已退费 3已过期
     */
    private Integer status;
    /**
     * 优惠使用时间
     */
    private String useTime;
    /**
     * 订单号
     */
    private String orderNum;
    /**
     * 优惠发放时间
     */
    private String sendTime;
    /**
     * 优惠发放时间
     */
    private Double deductMoney;
    /**
     * 车辆状态，1在场 2离场
     */
    private Integer carStatus;
    /**
     * 车辆状态，1在场 2离场
     */
    private Double getAmount;

}
