package com.icetech.order.domain.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @description: TODO
 * @auth: wangzhiwei
 * @date: 2023-08-01  09:53
 * @Version: 1.0
 */
@Data
public class BarrierGateExceptionDTO implements Serializable {


    /**
     * 车场编码 (app 传)
     */
    private String parkCode;
    /**
     * 车场ID (saas 传)
     */
    private List<Long> parkIds;
    /**
     * 开始时间 yyyy-MM-dd HH:mm:ss
     */
    @JsonFormat( pattern="yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date startDate;
    /**
     * 结束时间 yyyy-MM-dd HH:mm:ss
     */
    @JsonFormat( pattern="yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date endDate;

    /**
     * 页码
     */
    private Integer pageNo;
    /**
     * 分页大小
     */
    private Integer pageSize;
    /**
     * 是否加载图片
     */
    private Boolean loadImage = true;
}
