/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.order.domain.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.icetech.order.domain.entity.OrderDiscount;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@TableName(value="ice_order_pay_discount")
public class OrderPayDiscount
implements Serializable {
    private static final long serialVersionUID = 1L;
    @TableId(value="id", type=IdType.AUTO)
    private Long id;
    private Long parkId;
    private String orderNum;
    private String tradeNo;
    private String plateNum;
    private Integer type;
    private Integer carType;
    private Long enterTime;
    private Long exitTime;
    private Long lastPayTime;
    private Date payDate;
    private Integer payChannel;
    private String payTerminal;
    private Long orderTime;
    private String exitChannelId;
    private BigDecimal totalPrice;
    private BigDecimal paidPrice;
    private BigDecimal discountPrice;
    private Integer payWay;
    private BigDecimal merchantDiscountPrice;
    private BigDecimal thirdDiscountPrice;
    private BigDecimal vipDiscountPrice;
    private BigDecimal tollDiscountPrice;
    private String discountSource;
    private String merchantCouponsInfo;
    private String thirdCouponsInfo;
    private String vipCouponsInfo;
    private String tollCouponsInfo;
    @TableField(fill=FieldFill.INSERT)
    private Date createTime;

    public void addDiscountSource(Integer discountSource) {
        this.discountSource = this.discountSource == null ? discountSource.toString() : this.discountSource + "," + discountSource.toString();
    }

    public void setMerchantDiscountPrice(BigDecimal merchantDiscountPrice) {
        this.merchantDiscountPrice = merchantDiscountPrice != null ? merchantDiscountPrice.setScale(2, 4) : merchantDiscountPrice;
    }

    public void setThirdDiscountPrice(BigDecimal thirdDiscountPrice) {
        this.thirdDiscountPrice = thirdDiscountPrice != null ? thirdDiscountPrice.setScale(2, 4) : thirdDiscountPrice;
    }

    public void setVipDiscountPrice(BigDecimal vipDiscountPrice) {
        this.vipDiscountPrice = vipDiscountPrice != null ? vipDiscountPrice.setScale(2, 4) : vipDiscountPrice;
    }

    public void setTollDiscountPrice(BigDecimal tollDiscountPrice) {
        this.tollDiscountPrice = tollDiscountPrice != null ? tollDiscountPrice.setScale(2, 4) : tollDiscountPrice;
    }

    public static MerchantCouponsInfo getMerchantCouponsInfo(List<OrderDiscount> usedDiscountList, BigDecimal discountPrice) {
        List orderDiscounts = usedDiscountList.stream().filter(orderDiscount -> Integer.valueOf(1).equals(orderDiscount.getFrom())).collect(Collectors.toList());
        if (orderDiscounts.size() == 0) {
            return null;
        }
        MerchantCouponsInfo merchantCouponsInfo = new MerchantCouponsInfo();
        for (OrderDiscount orderDiscount2 : orderDiscounts) {
            merchantCouponsInfo.addMerchantId(orderDiscount2.getMerchantId());
            merchantCouponsInfo.addDiscountName(orderDiscount2.getDiscountName());
            merchantCouponsInfo.addDiscountType(orderDiscount2.getType());
        }
        merchantCouponsInfo.setDiscountPrice(discountPrice);
        return merchantCouponsInfo;
    }

    public static ThirdCouponsInfo getThirdCouponsInfo(List<OrderDiscount> usedDiscountList, BigDecimal discountPrice) {
        List orderDiscounts = usedDiscountList.stream().filter(orderDiscount -> Integer.valueOf(2).equals(orderDiscount.getFrom())).collect(Collectors.toList());
        if (orderDiscounts.size() == 0) {
            return null;
        }
        ThirdCouponsInfo thirdCouponsInfo = new ThirdCouponsInfo();
        for (OrderDiscount orderDiscount2 : orderDiscounts) {
            thirdCouponsInfo.addThirdId(orderDiscount2.getThirdId());
            thirdCouponsInfo.addDiscountName(orderDiscount2.getDiscountName());
            thirdCouponsInfo.addDiscountType(orderDiscount2.getType());
        }
        thirdCouponsInfo.setDiscountPrice(discountPrice);
        return thirdCouponsInfo;
    }

    public Long getParkTime() {
        Long parkTime = null;
        if (this.payDate == null) {
            return null;
        }
        if (this.lastPayTime != null) {
            parkTime = this.payDate.getTime() / 1000L - this.lastPayTime;
        } else if (this.enterTime != null) {
            parkTime = this.payDate.getTime() / 1000L - this.enterTime;
        }
        return parkTime;
    }

    public Long getId() {
        return this.id;
    }

    public Long getParkId() {
        return this.parkId;
    }

    public String getOrderNum() {
        return this.orderNum;
    }

    public String getTradeNo() {
        return this.tradeNo;
    }

    public String getPlateNum() {
        return this.plateNum;
    }

    public Integer getType() {
        return this.type;
    }

    public Integer getCarType() {
        return this.carType;
    }

    public Long getEnterTime() {
        return this.enterTime;
    }

    public Long getExitTime() {
        return this.exitTime;
    }

    public Long getLastPayTime() {
        return this.lastPayTime;
    }

    public Date getPayDate() {
        return this.payDate;
    }

    public Integer getPayChannel() {
        return this.payChannel;
    }

    public String getPayTerminal() {
        return this.payTerminal;
    }

    public Long getOrderTime() {
        return this.orderTime;
    }

    public String getExitChannelId() {
        return this.exitChannelId;
    }

    public BigDecimal getTotalPrice() {
        return this.totalPrice;
    }

    public BigDecimal getPaidPrice() {
        return this.paidPrice;
    }

    public BigDecimal getDiscountPrice() {
        return this.discountPrice;
    }

    public Integer getPayWay() {
        return this.payWay;
    }

    public BigDecimal getMerchantDiscountPrice() {
        return this.merchantDiscountPrice;
    }

    public BigDecimal getThirdDiscountPrice() {
        return this.thirdDiscountPrice;
    }

    public BigDecimal getVipDiscountPrice() {
        return this.vipDiscountPrice;
    }

    public BigDecimal getTollDiscountPrice() {
        return this.tollDiscountPrice;
    }

    public String getDiscountSource() {
        return this.discountSource;
    }

    public String getMerchantCouponsInfo() {
        return this.merchantCouponsInfo;
    }

    public String getThirdCouponsInfo() {
        return this.thirdCouponsInfo;
    }

    public String getVipCouponsInfo() {
        return this.vipCouponsInfo;
    }

    public String getTollCouponsInfo() {
        return this.tollCouponsInfo;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setParkId(Long parkId) {
        this.parkId = parkId;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public void setPlateNum(String plateNum) {
        this.plateNum = plateNum;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setCarType(Integer carType) {
        this.carType = carType;
    }

    public void setEnterTime(Long enterTime) {
        this.enterTime = enterTime;
    }

    public void setExitTime(Long exitTime) {
        this.exitTime = exitTime;
    }

    public void setLastPayTime(Long lastPayTime) {
        this.lastPayTime = lastPayTime;
    }

    public void setPayDate(Date payDate) {
        this.payDate = payDate;
    }

    public void setPayChannel(Integer payChannel) {
        this.payChannel = payChannel;
    }

    public void setPayTerminal(String payTerminal) {
        this.payTerminal = payTerminal;
    }

    public void setOrderTime(Long orderTime) {
        this.orderTime = orderTime;
    }

    public void setExitChannelId(String exitChannelId) {
        this.exitChannelId = exitChannelId;
    }

    public void setTotalPrice(BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
    }

    public void setPaidPrice(BigDecimal paidPrice) {
        this.paidPrice = paidPrice;
    }

    public void setDiscountPrice(BigDecimal discountPrice) {
        this.discountPrice = discountPrice;
    }

    public void setPayWay(Integer payWay) {
        this.payWay = payWay;
    }

    public void setDiscountSource(String discountSource) {
        this.discountSource = discountSource;
    }

    public void setMerchantCouponsInfo(String merchantCouponsInfo) {
        this.merchantCouponsInfo = merchantCouponsInfo;
    }

    public void setThirdCouponsInfo(String thirdCouponsInfo) {
        this.thirdCouponsInfo = thirdCouponsInfo;
    }

    public void setVipCouponsInfo(String vipCouponsInfo) {
        this.vipCouponsInfo = vipCouponsInfo;
    }

    public void setTollCouponsInfo(String tollCouponsInfo) {
        this.tollCouponsInfo = tollCouponsInfo;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String toString() {
        return "OrderPayDiscount(id=" + this.getId() + ", parkId=" + this.getParkId() + ", orderNum=" + this.getOrderNum() + ", tradeNo=" + this.getTradeNo() + ", plateNum=" + this.getPlateNum() + ", type=" + this.getType() + ", carType=" + this.getCarType() + ", enterTime=" + this.getEnterTime() + ", exitTime=" + this.getExitTime() + ", lastPayTime=" + this.getLastPayTime() + ", payDate=" + this.getPayDate() + ", payChannel=" + this.getPayChannel() + ", payTerminal=" + this.getPayTerminal() + ", orderTime=" + this.getOrderTime() + ", exitChannelId=" + this.getExitChannelId() + ", totalPrice=" + this.getTotalPrice() + ", paidPrice=" + this.getPaidPrice() + ", discountPrice=" + this.getDiscountPrice() + ", payWay=" + this.getPayWay() + ", merchantDiscountPrice=" + this.getMerchantDiscountPrice() + ", thirdDiscountPrice=" + this.getThirdDiscountPrice() + ", vipDiscountPrice=" + this.getVipDiscountPrice() + ", tollDiscountPrice=" + this.getTollDiscountPrice() + ", discountSource=" + this.getDiscountSource() + ", merchantCouponsInfo=" + this.getMerchantCouponsInfo() + ", thirdCouponsInfo=" + this.getThirdCouponsInfo() + ", vipCouponsInfo=" + this.getVipCouponsInfo() + ", tollCouponsInfo=" + this.getTollCouponsInfo() + ", createTime=" + this.getCreateTime() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderPayDiscount)) {
            return false;
        }
        OrderPayDiscount other = (OrderPayDiscount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$parkId = this.getParkId();
        Long other$parkId = other.getParkId();
        if (this$parkId == null ? other$parkId != null : !((Object)this$parkId).equals(other$parkId)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Integer this$carType = this.getCarType();
        Integer other$carType = other.getCarType();
        if (this$carType == null ? other$carType != null : !((Object)this$carType).equals(other$carType)) {
            return false;
        }
        Long this$enterTime = this.getEnterTime();
        Long other$enterTime = other.getEnterTime();
        if (this$enterTime == null ? other$enterTime != null : !((Object)this$enterTime).equals(other$enterTime)) {
            return false;
        }
        Long this$exitTime = this.getExitTime();
        Long other$exitTime = other.getExitTime();
        if (this$exitTime == null ? other$exitTime != null : !((Object)this$exitTime).equals(other$exitTime)) {
            return false;
        }
        Long this$lastPayTime = this.getLastPayTime();
        Long other$lastPayTime = other.getLastPayTime();
        if (this$lastPayTime == null ? other$lastPayTime != null : !((Object)this$lastPayTime).equals(other$lastPayTime)) {
            return false;
        }
        Integer this$payChannel = this.getPayChannel();
        Integer other$payChannel = other.getPayChannel();
        if (this$payChannel == null ? other$payChannel != null : !((Object)this$payChannel).equals(other$payChannel)) {
            return false;
        }
        Long this$orderTime = this.getOrderTime();
        Long other$orderTime = other.getOrderTime();
        if (this$orderTime == null ? other$orderTime != null : !((Object)this$orderTime).equals(other$orderTime)) {
            return false;
        }
        Integer this$payWay = this.getPayWay();
        Integer other$payWay = other.getPayWay();
        if (this$payWay == null ? other$payWay != null : !((Object)this$payWay).equals(other$payWay)) {
            return false;
        }
        String this$orderNum = this.getOrderNum();
        String other$orderNum = other.getOrderNum();
        if (this$orderNum == null ? other$orderNum != null : !this$orderNum.equals(other$orderNum)) {
            return false;
        }
        String this$tradeNo = this.getTradeNo();
        String other$tradeNo = other.getTradeNo();
        if (this$tradeNo == null ? other$tradeNo != null : !this$tradeNo.equals(other$tradeNo)) {
            return false;
        }
        String this$plateNum = this.getPlateNum();
        String other$plateNum = other.getPlateNum();
        if (this$plateNum == null ? other$plateNum != null : !this$plateNum.equals(other$plateNum)) {
            return false;
        }
        Date this$payDate = this.getPayDate();
        Date other$payDate = other.getPayDate();
        if (this$payDate == null ? other$payDate != null : !((Object)this$payDate).equals(other$payDate)) {
            return false;
        }
        String this$payTerminal = this.getPayTerminal();
        String other$payTerminal = other.getPayTerminal();
        if (this$payTerminal == null ? other$payTerminal != null : !this$payTerminal.equals(other$payTerminal)) {
            return false;
        }
        String this$exitChannelId = this.getExitChannelId();
        String other$exitChannelId = other.getExitChannelId();
        if (this$exitChannelId == null ? other$exitChannelId != null : !this$exitChannelId.equals(other$exitChannelId)) {
            return false;
        }
        BigDecimal this$totalPrice = this.getTotalPrice();
        BigDecimal other$totalPrice = other.getTotalPrice();
        if (this$totalPrice == null ? other$totalPrice != null : !((Object)this$totalPrice).equals(other$totalPrice)) {
            return false;
        }
        BigDecimal this$paidPrice = this.getPaidPrice();
        BigDecimal other$paidPrice = other.getPaidPrice();
        if (this$paidPrice == null ? other$paidPrice != null : !((Object)this$paidPrice).equals(other$paidPrice)) {
            return false;
        }
        BigDecimal this$discountPrice = this.getDiscountPrice();
        BigDecimal other$discountPrice = other.getDiscountPrice();
        if (this$discountPrice == null ? other$discountPrice != null : !((Object)this$discountPrice).equals(other$discountPrice)) {
            return false;
        }
        BigDecimal this$merchantDiscountPrice = this.getMerchantDiscountPrice();
        BigDecimal other$merchantDiscountPrice = other.getMerchantDiscountPrice();
        if (this$merchantDiscountPrice == null ? other$merchantDiscountPrice != null : !((Object)this$merchantDiscountPrice).equals(other$merchantDiscountPrice)) {
            return false;
        }
        BigDecimal this$thirdDiscountPrice = this.getThirdDiscountPrice();
        BigDecimal other$thirdDiscountPrice = other.getThirdDiscountPrice();
        if (this$thirdDiscountPrice == null ? other$thirdDiscountPrice != null : !((Object)this$thirdDiscountPrice).equals(other$thirdDiscountPrice)) {
            return false;
        }
        BigDecimal this$vipDiscountPrice = this.getVipDiscountPrice();
        BigDecimal other$vipDiscountPrice = other.getVipDiscountPrice();
        if (this$vipDiscountPrice == null ? other$vipDiscountPrice != null : !((Object)this$vipDiscountPrice).equals(other$vipDiscountPrice)) {
            return false;
        }
        BigDecimal this$tollDiscountPrice = this.getTollDiscountPrice();
        BigDecimal other$tollDiscountPrice = other.getTollDiscountPrice();
        if (this$tollDiscountPrice == null ? other$tollDiscountPrice != null : !((Object)this$tollDiscountPrice).equals(other$tollDiscountPrice)) {
            return false;
        }
        String this$discountSource = this.getDiscountSource();
        String other$discountSource = other.getDiscountSource();
        if (this$discountSource == null ? other$discountSource != null : !this$discountSource.equals(other$discountSource)) {
            return false;
        }
        String this$merchantCouponsInfo = this.getMerchantCouponsInfo();
        String other$merchantCouponsInfo = other.getMerchantCouponsInfo();
        if (this$merchantCouponsInfo == null ? other$merchantCouponsInfo != null : !this$merchantCouponsInfo.equals(other$merchantCouponsInfo)) {
            return false;
        }
        String this$thirdCouponsInfo = this.getThirdCouponsInfo();
        String other$thirdCouponsInfo = other.getThirdCouponsInfo();
        if (this$thirdCouponsInfo == null ? other$thirdCouponsInfo != null : !this$thirdCouponsInfo.equals(other$thirdCouponsInfo)) {
            return false;
        }
        String this$vipCouponsInfo = this.getVipCouponsInfo();
        String other$vipCouponsInfo = other.getVipCouponsInfo();
        if (this$vipCouponsInfo == null ? other$vipCouponsInfo != null : !this$vipCouponsInfo.equals(other$vipCouponsInfo)) {
            return false;
        }
        String this$tollCouponsInfo = this.getTollCouponsInfo();
        String other$tollCouponsInfo = other.getTollCouponsInfo();
        if (this$tollCouponsInfo == null ? other$tollCouponsInfo != null : !this$tollCouponsInfo.equals(other$tollCouponsInfo)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        return !(this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrderPayDiscount;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $parkId = this.getParkId();
        result = result * 59 + ($parkId == null ? 43 : ((Object)$parkId).hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Integer $carType = this.getCarType();
        result = result * 59 + ($carType == null ? 43 : ((Object)$carType).hashCode());
        Long $enterTime = this.getEnterTime();
        result = result * 59 + ($enterTime == null ? 43 : ((Object)$enterTime).hashCode());
        Long $exitTime = this.getExitTime();
        result = result * 59 + ($exitTime == null ? 43 : ((Object)$exitTime).hashCode());
        Long $lastPayTime = this.getLastPayTime();
        result = result * 59 + ($lastPayTime == null ? 43 : ((Object)$lastPayTime).hashCode());
        Integer $payChannel = this.getPayChannel();
        result = result * 59 + ($payChannel == null ? 43 : ((Object)$payChannel).hashCode());
        Long $orderTime = this.getOrderTime();
        result = result * 59 + ($orderTime == null ? 43 : ((Object)$orderTime).hashCode());
        Integer $payWay = this.getPayWay();
        result = result * 59 + ($payWay == null ? 43 : ((Object)$payWay).hashCode());
        String $orderNum = this.getOrderNum();
        result = result * 59 + ($orderNum == null ? 43 : $orderNum.hashCode());
        String $tradeNo = this.getTradeNo();
        result = result * 59 + ($tradeNo == null ? 43 : $tradeNo.hashCode());
        String $plateNum = this.getPlateNum();
        result = result * 59 + ($plateNum == null ? 43 : $plateNum.hashCode());
        Date $payDate = this.getPayDate();
        result = result * 59 + ($payDate == null ? 43 : ((Object)$payDate).hashCode());
        String $payTerminal = this.getPayTerminal();
        result = result * 59 + ($payTerminal == null ? 43 : $payTerminal.hashCode());
        String $exitChannelId = this.getExitChannelId();
        result = result * 59 + ($exitChannelId == null ? 43 : $exitChannelId.hashCode());
        BigDecimal $totalPrice = this.getTotalPrice();
        result = result * 59 + ($totalPrice == null ? 43 : ((Object)$totalPrice).hashCode());
        BigDecimal $paidPrice = this.getPaidPrice();
        result = result * 59 + ($paidPrice == null ? 43 : ((Object)$paidPrice).hashCode());
        BigDecimal $discountPrice = this.getDiscountPrice();
        result = result * 59 + ($discountPrice == null ? 43 : ((Object)$discountPrice).hashCode());
        BigDecimal $merchantDiscountPrice = this.getMerchantDiscountPrice();
        result = result * 59 + ($merchantDiscountPrice == null ? 43 : ((Object)$merchantDiscountPrice).hashCode());
        BigDecimal $thirdDiscountPrice = this.getThirdDiscountPrice();
        result = result * 59 + ($thirdDiscountPrice == null ? 43 : ((Object)$thirdDiscountPrice).hashCode());
        BigDecimal $vipDiscountPrice = this.getVipDiscountPrice();
        result = result * 59 + ($vipDiscountPrice == null ? 43 : ((Object)$vipDiscountPrice).hashCode());
        BigDecimal $tollDiscountPrice = this.getTollDiscountPrice();
        result = result * 59 + ($tollDiscountPrice == null ? 43 : ((Object)$tollDiscountPrice).hashCode());
        String $discountSource = this.getDiscountSource();
        result = result * 59 + ($discountSource == null ? 43 : $discountSource.hashCode());
        String $merchantCouponsInfo = this.getMerchantCouponsInfo();
        result = result * 59 + ($merchantCouponsInfo == null ? 43 : $merchantCouponsInfo.hashCode());
        String $thirdCouponsInfo = this.getThirdCouponsInfo();
        result = result * 59 + ($thirdCouponsInfo == null ? 43 : $thirdCouponsInfo.hashCode());
        String $vipCouponsInfo = this.getVipCouponsInfo();
        result = result * 59 + ($vipCouponsInfo == null ? 43 : $vipCouponsInfo.hashCode());
        String $tollCouponsInfo = this.getTollCouponsInfo();
        result = result * 59 + ($tollCouponsInfo == null ? 43 : $tollCouponsInfo.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        return result;
    }

    public static enum DiscountSourceEnum {
        MERCHANT_COUPONS("1"),
        THIRD_COUPONS("2"),
        VIP_COUPONS("3"),
        TOLL_COUPONS("4");

        private final String desc;

        private DiscountSourceEnum(String desc) {
            this.desc = desc;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static class TollCouponsInfo {
        private String exitOperaAccount;
        private Integer exitTerminal;
        private BigDecimal discountPrice;

        public String getExitOperaAccount() {
            return this.exitOperaAccount;
        }

        public Integer getExitTerminal() {
            return this.exitTerminal;
        }

        public BigDecimal getDiscountPrice() {
            return this.discountPrice;
        }

        public void setExitOperaAccount(String exitOperaAccount) {
            this.exitOperaAccount = exitOperaAccount;
        }

        public void setExitTerminal(Integer exitTerminal) {
            this.exitTerminal = exitTerminal;
        }

        public void setDiscountPrice(BigDecimal discountPrice) {
            this.discountPrice = discountPrice;
        }

        public String toString() {
            return "OrderPayDiscount.TollCouponsInfo(exitOperaAccount=" + this.getExitOperaAccount() + ", exitTerminal=" + this.getExitTerminal() + ", discountPrice=" + this.getDiscountPrice() + ")";
        }
    }

    public static class VipCouponsInfo {
        private String typeId;
        private String discountType;
        private BigDecimal discountPrice;

        public void addTypeId(Integer typeId) {
            if (this.typeId == null) {
                this.typeId = typeId.toString();
            } else if (!Arrays.asList(this.typeId.split(",")).contains(typeId.toString())) {
                this.typeId = this.typeId + "," + typeId.toString();
            }
        }

        public void setDiscountPrice(BigDecimal discountPrice) {
            this.discountPrice = discountPrice != null ? discountPrice.setScale(2, 4) : discountPrice;
        }

        public void addDiscountPrice(BigDecimal discountPrice) {
            this.discountPrice = this.discountPrice == null ? discountPrice : this.discountPrice.add(discountPrice).setScale(2, 4);
        }

        public void addDiscountType(Integer discountType) {
            if (this.discountType == null) {
                this.discountType = discountType.toString();
            } else if (!Arrays.asList(this.discountType.split(",")).contains(discountType.toString())) {
                this.discountType = this.discountType + "," + discountType.toString();
            }
        }

        public String getTypeId() {
            return this.typeId;
        }

        public String getDiscountType() {
            return this.discountType;
        }

        public BigDecimal getDiscountPrice() {
            return this.discountPrice;
        }

        public void setTypeId(String typeId) {
            this.typeId = typeId;
        }

        public void setDiscountType(String discountType) {
            this.discountType = discountType;
        }

        public String toString() {
            return "OrderPayDiscount.VipCouponsInfo(typeId=" + this.getTypeId() + ", discountType=" + this.getDiscountType() + ", discountPrice=" + this.getDiscountPrice() + ")";
        }
    }

    public static class ThirdCouponsInfo {
        private String thirdId;
        private String discountType;
        private String discountName;
        private BigDecimal discountPrice;

        public void addThirdId(Long thirdId) {
            if (thirdId == null) {
                return;
            }
            if (this.thirdId == null) {
                this.thirdId = thirdId.toString();
            } else if (!Arrays.asList(this.thirdId.split(",")).contains(thirdId.toString())) {
                this.thirdId = this.thirdId + "," + thirdId;
            }
        }

        public void addDiscountType(Integer discountType) {
            if (this.discountType == null) {
                this.discountType = discountType.toString();
            } else if (!this.discountType.contains(discountType.toString())) {
                this.discountType = this.discountType + "," + discountType.toString();
            }
        }

        public void addDiscountName(String discountName) {
            if (this.discountName == null) {
                this.discountName = discountName;
            } else if (!Arrays.asList(this.discountName.split(",")).contains(discountName)) {
                this.discountName = this.discountName + "," + discountName;
            }
        }

        public void setDiscountPrice(BigDecimal discountPrice) {
            this.discountPrice = discountPrice != null ? discountPrice.setScale(2, 4) : discountPrice;
        }

        public String getThirdId() {
            return this.thirdId;
        }

        public String getDiscountType() {
            return this.discountType;
        }

        public String getDiscountName() {
            return this.discountName;
        }

        public BigDecimal getDiscountPrice() {
            return this.discountPrice;
        }

        public void setThirdId(String thirdId) {
            this.thirdId = thirdId;
        }

        public void setDiscountType(String discountType) {
            this.discountType = discountType;
        }

        public void setDiscountName(String discountName) {
            this.discountName = discountName;
        }

        public String toString() {
            return "OrderPayDiscount.ThirdCouponsInfo(thirdId=" + this.getThirdId() + ", discountType=" + this.getDiscountType() + ", discountName=" + this.getDiscountName() + ", discountPrice=" + this.getDiscountPrice() + ")";
        }
    }

    public static class MerchantCouponsInfo {
        private String merchantId;
        private String discountType;
        private String discountName;
        private BigDecimal discountPrice;

        public void addMerchantId(Long merchantId) {
            if (this.merchantId == null) {
                this.merchantId = merchantId.toString();
            } else if (!Arrays.asList(this.merchantId.split(",")).contains(merchantId.toString())) {
                this.merchantId = this.merchantId + "," + merchantId.toString();
            }
        }

        public void addDiscountType(Integer discountType) {
            if (this.discountType == null) {
                this.discountType = discountType.toString();
            } else if (!this.discountType.contains(discountType.toString())) {
                this.discountType = this.discountType + "," + discountType.toString();
            }
        }

        public void addDiscountName(String discountName) {
            if (this.discountName == null) {
                this.discountName = discountName;
            } else if (!Arrays.asList(this.discountName.split(",")).contains(discountName)) {
                this.discountName = this.discountName + "," + discountName;
            }
        }

        public void setDiscountPrice(BigDecimal discountPrice) {
            this.discountPrice = discountPrice != null ? discountPrice.setScale(2, 4) : discountPrice;
        }

        public String getMerchantId() {
            return this.merchantId;
        }

        public String getDiscountType() {
            return this.discountType;
        }

        public String getDiscountName() {
            return this.discountName;
        }

        public BigDecimal getDiscountPrice() {
            return this.discountPrice;
        }

        public void setMerchantId(String merchantId) {
            this.merchantId = merchantId;
        }

        public void setDiscountType(String discountType) {
            this.discountType = discountType;
        }

        public void setDiscountName(String discountName) {
            this.discountName = discountName;
        }

        public String toString() {
            return "OrderPayDiscount.MerchantCouponsInfo(merchantId=" + this.getMerchantId() + ", discountType=" + this.getDiscountType() + ", discountName=" + this.getDiscountName() + ", discountPrice=" + this.getDiscountPrice() + ")";
        }
    }
}

