package com.icetech.order.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.icetech.order.domain.entity.OrderBack;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @description: 折返返回
 * @auth: wangzhiwei
 * @date: 2023-07-28  15:02
 * @Version: 1.0
 */
@Data
@ExcelIgnoreUnannotated
@AllArgsConstructor
@NoArgsConstructor
public class OrderBackVO extends OrderBack {

    /**
     * 车场编号
     */
    private String parkCode;

    /**
     * 1在场2离场
     */
    private Integer serviceStatus;
    /**
     * 车场名称
     */
    @ExcelProperty(value = "车场名称")
    private String parkName;
    /**
     * 入场图片
     */
    private String enterImg;
    /**
     * 离场图片
     */
    private String exitImg;

    /**
     * 入口位置
     */
    private String enterNo;

    /**
     * 出口位置
     */
    private String exitNo;
    @ExcelProperty(value = "停车时长")
    private String parkingTimeStr;

    /**
     * 是否有子区域 0：否，1：是，默认为0
     */
    private Integer hasSon;
    /**
     * 订单表的ID
     */
    private Long orderId;
    /** 是否存在场中场(0否，1是默认0) */
    protected Integer isInterior;

    /**
     * 是否加装监控相机，0：未装，1：已装
     */
    private Integer hasMorCamera;
}
