package com.icetech.order.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.converters.date.DateStringConverter;
import com.icetech.excel.anno.ExcelDictFormat;
import com.icetech.excel.convert.ExcelDictConvert;
import lombok.Data;

import java.util.Date;

@Data
@ExcelIgnoreUnannotated
public class OrderBackEnterVO {

    /**
     * 车场编号
     */
    private String parkCode;

    /**
     * 1在场2离场
     */
    private Integer serviceStatus;
    /**
     * 车场名称
     */
    @ExcelProperty(value = "车场名称")
    private String parkName;
    /**
     * 入场图片
     */
    private String enterImg;
    /**
     * 离场图片
     */
    private String exitImg;

    /**
     * 入口位置
     */
    private String enterNo;

    /**
     * 出口位置
     */
    private String exitNo;


    private String parkingTimeStr;

    /**
     * 是否有子区域 0：否，1：是，默认为0
     */
    private Integer hasSon;
    /**
     * 订单表的ID
     */
    private Long orderId;
    /**
     * 是否存在场中场(0否，1是默认0)
     */
    protected Integer isInterior;

    /**
     * 主键自增长id
     */
    private Long id;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 车牌号
     */
    @ExcelProperty(value = "车牌号")
    private String plateNum;

    /**
     * 车辆类型(1临时车2月卡车3特殊车辆，默认1)
     */
    @ExcelProperty(value = "车辆类型", converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "1=临时车,2=月卡车,3=特殊车辆")
    protected Integer type;

    /**
     * 进场时间
     */
    private Long enterTime;

    /**
     * 离场时间
     */
    private Long exitTime;

    /**
     * 倒车返场时间
     */
    private Long backStartTime;

    /**
     * 返回场内时间
     */
    private Long backEndTime;

    /**
     * 通道名称
     */
    @ExcelProperty(value = "报警位置")
    private String channelName = "";
    private Long channelId;

    /**
     * 车型(2大型车、1小型车，默认1)
     */
    private Integer carType;

    /**
     * 通道类型 1 - 入口  2-出口
     */
    private Integer inandoutType;

    /**
     * 视频ID
     */
    private String videoId;
    /**
     * 视频证据地址
     */
    private String evidenceVideo;

    /**
     * 创建时间
     */
    @ExcelProperty(value = "报警时间", converter = DateStringConverter.class)
    private Date createTime;

}
