package com.icetech.order.domain.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * ice_report_bclient
 * @author
 */
@Data
@TableName(value = "`ice_report_bclient`")
public class ReportBclient implements Serializable {
    /**
     * id
     */
    @TableId(value = "`id`")
    private Integer id;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 收费员姓名
     */
    private String name;

    /**
     * 收费员类型
     */
    private Integer type;

    /**
     * 所在位置
     */
    private String position;

    /**
     * 结账号，和记录明细、订单表记录关联
     */
    private String billid;

    /**
     * 应收总金额，当班收费员结账时应付金额
     */
    private BigDecimal charge;

    /**
     * 实收总金额 当班收费员结账时的实收
     */
    private BigDecimal realcharge;

    /**
     * 优惠总金额
     */
    private BigDecimal disamount;

    /**
     * 电子支付总金额；
     */
    private BigDecimal noncashcharge;

    /**
     * 无感支付总金额
     */
    private BigDecimal nosebsecharge;

    /**
     * 免费放行金额
     */
    private BigDecimal freepasscharge;

    /**
     * 异常放行金额
     */
    private BigDecimal abnormalcharge;

    /**
     * 用户名
     */
    private String username;

    /**
     * 上岗时间 结账开始时间
     */
    private Date startTime;

    /**
     * 结账日期
     */
    private Date endTime;

    /**
     * 交易笔数
     */
    private Integer payNum;

    /**
     * 现金收入
     */
    private BigDecimal amount;

    /**
     * 创建时间
     */
    private Date createTime;

    private static final long serialVersionUID = 1L;
}
