package com.icetech.order.domain.entity;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;

import java.io.Serializable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 退款记录表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2022-04-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_order_refund_record")
public class OrderRefundRecord implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 车场id
     */
    private Integer parkId;

    /**
     * 系统交易流水号
     */
    private String tradeNo;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 商户交易流水号
     */
    private String outTradeNo;

    /**
     * 车牌号
     */
    private String plateNo;

    /**
     * 退款金额
     */
    private BigDecimal amount;

    /**
     * 1现金，2微信，3支付宝，4银联
     */
    private Integer payWay;

    /**
     * 支付时间
     */
    private Date payTime;

    /**
     * 退款交易流水号
     */
    private String refundTradeNo;

    /**
     * 退款状态 1=退款中 2=退款成功  3=退款失败
     */
    private Integer refundStatus;

    /**
     * 退款原因
     */
    private String refundReason;

    /**
     * 退款时间
     */
    private Date refundTime;

    /**
     * 附件 json 数组
     */
    private String attachment;

    /**
     * 备注
     */
    private String remark;

    /**
     * 操作人
     */
    private String optionName;

    /**
     * 操作时间
     */
    private Date optionTime;

    /**
     * 退款失败原因
     */
    private String refundFailMsg;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;


}
