package com.icetech.order.domain.entity;

import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;

@Data
@Accessors(chain = true)
@TableName("`ice_order_pay_detail`")
public class OrderPayDetail implements Serializable {
    /**
     * 主键自增长id
     */
    @TableId("`id`")
    protected Long id;
    /**
     * 停车场id
     */
    @TableField("`park_id`")
    protected Long parkId;
    /**
     * 区域id
     */
    @TableField("`region_id`")
    protected Long regionId;
    /**
     * 子订单ID
     */
    @TableField("`order_son_id`")
    protected Long orderSonId;
    /**
     * 订单号
     */
    @TableField("`order_num`")
    protected String orderNum;
    /**
     * 交易流水号
     */
    @TableField("`trade_no`")
    protected String tradeNo;
    /**
     * 支付状态，1：支付中，2：已支付，3：取消
     */
    @TableField("`pay_status`")
    protected Integer payStatus;
    /**
     * 退款状态   1=未退款 2=退款中 3=退款成功 4=退款失败
     */
    @TableField("`refund_status`")
    protected Integer refundStatus;
    /**
     * 缴费方式1现金，2微信，3支付宝，4银联
     */
    @TableField("`pay_way`")
    protected Integer payWay;
    /**
     * 进入当前区域的入场时间
     */
    @TableField("`enter_time`")
    protected Long enterTime;
    /**
     * 驶离当前区域的离场时间
     */
    @TableField("`exit_time`")
    protected Long exitTime;
    /**
     * 车牌号
     */
    @TableField("`plate_num`")
    protected String plateNum;
    /**
     * 支付时间
     */
    @TableField("`pay_time`")
    protected Long payTime;
    /**
     * 应收金额
     */
    @TableField("`total_price`")
    protected Double totalPrice;
    /**
     * 实收金额
     */
    @TableField("`paid_price`")
    protected Double paidPrice;
    /**
     * 优惠金额
     */
    @TableField("`discount_price`")
    protected Double discountPrice;
    /**
     * 车辆类型(1临时车2月卡车3特殊车辆 4VIP车辆 5访客车辆 6储值卡车，默认1)
     */
    @TableField("`plate_type`")
    protected Integer plateType;
}
