package com.icetech.order.domain.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.converters.date.DateStringConverter;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.icetech.excel.anno.ExcelDictFormat;
import com.icetech.excel.convert.ExcelDictConvert;
import com.icetech.excel.convert.TimestampSecondStringConverter;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 订单欠费记录表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @date 2023-03-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@AllArgsConstructor
@TableName("ice_order_notpay")
public class OrderNotpay implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 车牌号
     */
    @ExcelProperty(value = "车牌号")
    private String plateNum;

    /**
     * 车辆类型(1临时车2月卡车3特殊车辆，默认1)
     */
    @ExcelProperty(value = "车辆类型",converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "1=临时车,2=月卡车,3=特殊车辆")
    private Integer type;

    /**
     * 进场时间
     */
    @ExcelProperty(value = "入场时间",converter = TimestampSecondStringConverter.class)
    private Long enterTime;

    /**
     * 离场时间
     */
    @ExcelProperty(value = "离场时间",converter = TimestampSecondStringConverter.class)
    private Long exitTime;

    /**
     * 车型(2大型车、1小型车，默认1)
     */
    private Integer carType;

    /**
     * 欠费金额
     */
    @ExcelProperty(value = "总应收")
    private BigDecimal totalPrice;

    /**
     * 补缴金额
     */
    @ExcelProperty(value = "总实收")
    private BigDecimal paidPrice;

    /**
     * 优惠金额
     */
    @ExcelProperty(value = "总优惠")
    private BigDecimal discountPrice;

    /**
     * 状态（1未补缴、2已补缴、3已删除、4待审核、5已取消）
     */
    private Integer status;

    /**
     * 补缴类型，1：入口补缴、2：出口补缴
     */
    private Integer mendPayType;

    /**
     * 补缴通道名称
     */
    @ExcelProperty(value = "补缴位置")
    private String channelName;
    /**
     * 报警通道名称
     */
    private Long channelId;

    /**
     * 操作员
     */
    private String operAccount;

    /**
     * 操作原因
     */
    private String operReason;

    /**
     * 删除/补缴时间
     */
    @ExcelProperty(value = "补缴时间",converter = DateStringConverter.class)
    private Date operTime;

    private Long lastPayTime;
    /**
     * 视频ID
     */
    private String videoId;
    /**
     * 视频证据
     */
    private String evidenceVideo;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    @ExcelProperty(value = "报警时间",converter = DateStringConverter.class)
    private Date createTime;

    /**
     * 是否加装监控相机，0：未装，1：已装
     */
    @TableField(exist=false)
    private Integer hasMorCamera;

    /** 订单来源(1-场库; 2-路内) */
    @TableField(exist = false)
    protected int orderSource = ORDER_SOURCE_PARK;

    public static final Integer ORDER_SOURCE_PARK = 1;
    public static final Integer ORDER_SOURCE_ROAD = 2;
}
