package com.icetech.order.domain.entity;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 优惠记录表
 */
@Getter
@Setter
@ToString
@TableName(value = "`ice_order_discount`")
public class OrderDiscount implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int FROM_LOCAL = 0;
    public static final int FROM_CLOUD = 1;
    public static final int FROM_THIRD = 2;
    /**
     * 第三方-特来电
     */
    public static final int FROM_THIRD_TELD = 21;

    /**
     * 主键自增长id
     */
    @TableId(value = "`id`")
    protected Long id;
    /**
     * 车场id
     */
    @TableField(value = "`park_id`")
    protected Long parkId;
    /**
     * 订单号
     */
    @TableField(value = "`order_num`")
    protected String orderNum;
    /**
     * 交易流水号
     */
    @TableField(value = "`trade_no`")
    protected String tradeNo;
    /**
     * 关联商户下发的优惠模板ID
     */
    @TableField(value = "`merchant_dis_id`")
    protected Long merchantDisId;
    /**
     * 优惠券名称
     */
    @TableField(value = "`discount_name`")
    protected String discountName;
    /**
     * 关联商户ID
     */
    @TableField(value = "`merchant_id`")
    protected Long merchantId;
    /**
     * 第三方ID
     */
    @TableField(value = "`third_id`")
    protected Long thirdId;
    /**
     * 优惠来源（0.本地发放,1:平台发放,2:第三方）默认为0
     */
    @TableField(value = "`from`")
    protected Integer from;
    /**
     * 优惠券编号
     */
    @TableField(value = "`discount_no`")
    protected String discountNo;
    /**
     * 车牌号
     */
    @TableField(value = "`plate_num`")
    protected String plateNum;
    /**
     * 在场状态
     */
    @TableField(value = "`car_status`")
    protected Integer carStatus;
    /**
     * 优惠类型1全免2减免时间3减免金额4折扣
     */
    @TableField(value = "`type`")
    protected Integer type;
    /**
     * 全免优惠时，此字段无需上报；时间优惠时以分钟为单位，金额优惠时以元为单位；折扣优惠时取值范围大于0且小于10，比如打99折时，值为9.9。
     */
    @TableField(value = "`amount`")
    protected String amount;
    /**
     * 操作人
     */
    @TableField(value = "`oper_account`")
    protected String operAccount;
    /**
     * 状态(0未使用1已使用默认0
     */
    @TableField(value = "`status`")
    protected Integer status;
    /**
     * 单张优惠扣除金额（元）
     */
    @TableField(value = "`deduct_money`")
    protected Double deductMoney;
    /**
     * 余额扣减金额
     */
    @TableField(value = "`reduce_balance`", exist = false)
    private String reduceBalance;
    /**
     * 实际优惠金额
     */
    @TableField(value = "`get_amount`")
    protected Double getAmount;
    /**
     * 发放时间
     */
    @TableField(value = "`send_time`")
    protected Date sendTime;
    /**
     * 使用时间
     */
    @TableField(value = "`use_time`")
    protected Date useTime;
    /**
     * 使用时间
     */
    @TableField(value = "`update_time`")
    protected Date updateTime;
    /**
     * 优惠券生效时间
     */
    @TableField(value = "`start_time`")
    protected Date startTime;
    /**
     * 到期时间
     */
    @TableField(value = "`expire_time`")
    protected Date expireTime;
    /**
     * 第三方优惠编号
     */
    @TableField(exist = false)
    private String outDiscountNo;
    /**
     * 删除标识，0：正常，1：已删除
     */
    @TableField(value = "`del_flag`")
    private Integer delFlag;

    /**
     * 备注
     */
    @TableField(value = "`remark`")
    private String remark;

    public static String buildDiscountName(Integer type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case 1:
                return "全免券";
            case 2:
                return "时长券";
            case 3:
                return "金额券";
            case 4:
                return "折扣券";
            default:
                return "优惠券";
        }
    }
}
