package com.icetech.order.domain.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 订单车辆详情信息表
 */
@Data
@Accessors(chain = true)
@TableName(value = "`ice_order_car_info`")
public class OrderCarInfo implements Serializable {
    /**
     * 主键自增长id
     */
    @TableId(value = "`id`")
    protected Long id;
    /**
     * 订单号
     */
    @TableField(value = "`order_num`")
    protected String orderNum;
    /**
     * 车辆品牌
     */
    @TableField(value = "`car_brand`")
    protected String carBrand;
    /**
     * 车辆颜色
     */
    @TableField(value = "`car_color`")
    protected String carColor;
    /**
     * 车牌颜色
     */
    @TableField(value = "`plate_color`")
    protected String plateColor;
    /**
     * 入口位置
     */
    @TableField(value = "`enter_channel_id`")
    protected String enterChannelId;
    /**
     * 出口位置
     */
    @TableField(value = "`exit_channel_id`")
    protected String exitChannelId;
    /**
     * 入口通道ID
     */
    @TableField(value = "`enter_no`")
    protected String enterNo;
    /**
     * 出口通道ID
     */
    @TableField(value = "`exit_no`")
    protected String exitNo;
    /**
     * 入场方式：1车牌识别入场，2遥控器抬杆入场，3无牌车扫码入场，4软件人工入场,5断电应急
     */
    @TableField(value = "`enter_way`")
    protected Integer enterWay;
    /**
     * 入场终端，1 云坐席、2 车场帮APP 、3 云岗亭、4岗亭计费软件、5 车场监控、6 saas导入'
     */
    @TableField(value = "`enter_terminal`")
    protected Integer enterTerminal;
    /**
     * 软件人工入场的操作人账号
     */
    @TableField(value = "`enter_oper_account`")
    protected String enterOperAccount;
    /**
     * 软件人工离场的操作人账号
     */
    @TableField(value = "`exit_oper_account`")
    protected String exitOperAccount;
    /**
     * 入场图片
     */
    @TableField(value = "`enter_image`")
    protected String enterImage;
    /**
     * 出场方式：1车牌识别，2遥控器抬杆，3无牌车扫码，4软件人工，5断电应急
     */
    @TableField(value = "`exit_way`")
    protected Integer exitWay;
    /**
     * 离场终端，1 云坐席、2 车场帮APP 、3 云岗亭、4岗亭计费软件、5 车场监控'
     */
    @TableField(value = "`exit_terminal`")
    protected Integer exitTerminal;
    /**
     * 离场图片
     */
    @TableField(value = "`exit_image`")
    protected String exitImage;
    /**
     * 入场小图片
     */
    @TableField(value = "`small_enter_image`")
    protected String smallEnterImage;
    /**
     * 离场小图片
     */
    @TableField(value = "`small_exit_image`")
    protected String smallExitImage;
    /**
     * 入场车牌置信度
     */
    @TableField(value = "`enter_reliability`")
    protected Integer enterReliability;
    /**
     * 离场车牌置信度
     */
    @TableField(value = "`exit_reliability`")
    protected Integer exitReliability;
    /**
     * 标签集，多个id用逗号隔开
     */
    @TableField(value = "`tags`")
    protected String tags;
    /**
     * 备注
     */
    @TableField(value = "`remark`")
    protected String remark;
    /**
     * 离场备注
     */
    @TableField(value = "`exit_remark`")
    protected String exitRemark;
}
