package com.icetech.order.domain.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.converters.date.DateStringConverter;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import com.icetech.excel.anno.ExcelDictFormat;
import com.icetech.excel.convert.ExcelDictConvert;
import com.icetech.excel.convert.TimestampSecondStringConverter;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 折返回场记录表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @date 2023-07-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_order_back")
public class OrderBack implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 车牌号
     */
    @ExcelProperty(value = "车牌号")
    private String plateNum;

    /**
     * 车辆类型(1临时车2月卡车3特殊车辆，默认1)
     */
    @ExcelProperty(value = "车辆类型",converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "1=临时车,2=月卡车,3=特殊车辆")
    protected Integer type;

    /**
     * 进场时间
     */
    @ExcelProperty(value = "入场时间",converter = TimestampSecondStringConverter.class)
    private Long enterTime;

    /**
     * 离场时间
     */
    @ExcelProperty(value = "离场时间",converter = TimestampSecondStringConverter.class)
    private Long exitTime;

    /**
     * 倒车返场时间
     */
    private Long backStartTime;

    /**
     * 返回场内时间
     */
    private Long backEndTime;

    /**
     * 通道名称
     */
    @ExcelProperty(value = "报警位置")
    private String channelName = "";
    private Long channelId;

    /**
     * 车型(2大型车、1小型车，默认1)
     */
    private Integer carType;

    /**
     * 通道类型 1 - 入口  2-出口
     */
    private Integer inandoutType;

    /**
     * 审核状态 0-待审核，1-已审核
     */
    private Integer reviewStatus;

    /**
     * 视频ID
     */
    private String videoId;
    /**
     * 视频证据地址
     */
    private String evidenceVideo;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    @ExcelProperty(value = "报警时间",converter = DateStringConverter.class)
    private Date createTime;


}
