package com.icetech.order.domain.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 道闸异常记录表
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2023-08-01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_barrier_gate_exception")
public class BarrierGateException implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 车场id
     */
    private Long parkId;

    /**
     * 上报设备的sn号
     */
    private String reportSn;

    /**
     * 通道ID
     */
    private Long channelId;
    /**
     * 通道名称
     */
    private String channelName;

    /**
     * 报警时间
     */
    private Date alarmTime;

    /**
     * 状态，1：正常，2：异常
     */
    private Integer status;

    /**
     * 恢复时间
     */
    private Date recoverTime;

    /**
     * 异常图片
     */
    private String exceptionImage;

    /**
     * 恢复图片
     */
    private String recoverImage;
    /**
     * 恢复图片
     */
    private Date createTime;


}
