package com.icetech.order.domain.dto;

import com.icetech.common.annotation.NotNull;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 优惠记录查询参数和响应
 * @author fangct
 */
@Data
public class StoredCardRecordDto implements Serializable {

    //查询参数
    private Integer pageSize = 10;
    private Integer pageNo = 1;
    /**
     * 车场ID集合
     */
    private List<Long> parkIdList;
    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 开始时间
     */
    @NotNull
    private String startTime;

    /**
     * 结束时间
     */
    @NotNull
    private String endTime;
    private String cardOwner;
    private String phone;
    private List<Integer> cardOpertypeList;

    //响应参数
    private Long id;
    /**
     * 车场ID
     */
    private Long parkId;

    /**
     * 车场名称
     */
    private String parkName;
    /**
     * 充值金额
     */
    private Double rechargePrice;
    /**
     * 余额
     */
    private Double balance;
    /**
     * 操作类型1 新增 2 充值 3 编辑 4 删除
     */
    private Integer cardOpertype;
    private String regionId;


}
