package com.icetech.order.domain.dto;

import com.icetech.common.annotation.NotNull;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class PayDiscountListDTO implements Serializable {
    /**
     * 车场名称
     */
    private List<Long> parkIdList;
    /**
     * 车牌号
     */
    private String plateNum;
    /**
     * 支付开始时间
     */
    @NotNull
    private String startTime;
    /**
     * 支付结束时间
     */
    private String endTime;
    /**
     * 优惠来源（1商户端优惠、2第三方优惠、3vip车辆抵扣优惠、4收费员免费放行优惠）
     */
    private List<Integer> discountSources;

    private Long pageNo;
    private Long pageSize;
}
