package com.icetech.order.domain.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Description: TODO
 * @Author: wangzhiwei
 * @CreateTime: 2023-03-09  13:37
 * @Version: 1.0
 */
@Data
public class NotPayRecordQueryDTO implements Serializable {
    /**
     * 车场编码 (app 传)
     */
    private String parkCode;
    /**
     * 车场ID (saas 传)
     */
    private List<Long> parkIds;
    /**
     * 状态（1未补缴、2已补缴、3已删除）
     */
    private Integer status;
    /**
     * 补缴类型 1：入口补缴、2：出口补缴
     */
    private List<Integer> mendPayType;
    /**
     * 车牌号
     */
    private String plateNum;
    /**
     * 开始时间 yyyy-MM-dd HH:mm:ss
     */
    @JsonFormat( pattern="yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    @NotNull(message = "查询开始时间不能为空")
    private Date startDate;
    /**
     * 结束时间 yyyy-MM-dd HH:mm:ss
     */
    @JsonFormat( pattern="yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    @NotNull(message = "查询结束时间不能为空")
    private Date endDate;
    /**
     * 页码
     */
    private Integer pageNo = 1;
    /**
     * 分页大小
     */
    private Integer pageSize = 10;
    /**
     * 是否加载图片
     */
    private Boolean loadImage = true;

}
