package com.icetech.fee.dao.merchant;

import com.icetech.cloudcenter.domain.response.RechargeDetailDto;
import com.icetech.cloudcenter.domain.response.RechargeListDto;
import com.icetech.cloudcenter.domain.response.SubRechargeListDto;
import com.icetech.fee.domain.entity.merchant.MerchantRecharge;
import com.icetech.db.mybatis.base.mapper.SuperMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 商户充值记录表
 *
 * Created by xuxueli on '2019-02-15 14:42:09'.
 */
@Mapper
public interface MerchantRechargeDao extends SuperMapper<MerchantRecharge> {



    /**
     * 按月汇总充值金额
     * @param rechargeListVo
     * @return
     */
    List<RechargeListDto> countMonth(Map<String, Object> rechargeListVo);

    /**
     * 查询当月充值明细
     * @param rechargeListVo
     * @return
     */
    List<SubRechargeListDto> monthRecharge(Map<String, Object> rechargeListVo);

    /**
     * 充值记录
     * @param recordId
     * @return
     */
   RechargeDetailDto findRechargeDetail(Integer recordId);

    /**
     * 按范围汇总金额
     * @param merchantId
     * @param startDate
     * @param endDate
     * @return
     */
   String countScope(@Param("merchantId") Long merchantId, @Param("startDate") String startDate, @Param("endDate") String endDate);

}
